/*
 * @(#)PartFactory.java
 * 
 */

package collage.generic;

import openstar.generic.*;

/**
 * Part factory base class.
 * <p>
 * For a conceptual overview, refer to the description of the 
 * <code>Edge</code> class in the kernel package, and to the
 * description of <code>Factory</code> in the openstar.generic
 * package.
 * <p>
 * This class provides a common framework for the creation of user-defined
 * parts that implement specific shapes and/or behaviour. It
 * can be used, for example, by a generic collage
 * grammar parser, or other tools, to instantiate parts of previously
 * unknown classes.
 * <p>
 * Normally, one will derive an own class from PartFactory that implements
 * the specific parameters and creates instances of arbitrary <code>
 * Edge</code> objects. However, it is also possible to use the PartFactory
 * class directly. In this case, the generated <code>Edge</code> objects
 * are instances of class <code>Part</code>, which is a generic part class
 * that accepts arbitrary parameters.
 * 
 * @version 04 Jun 1997
 * @author 	Nils Schwabe
 */ 
public class PartFactory extends Factory
{

protected final static String DIMENSIONS = "dimensions";

/**
 * Creates a new part instance.
 * <p>
 * All objects created from descendants of this factory class must
 * return <code>Edge</code>-objects. However, this cannot be
 * enforced at compile-time due to the generic character of the
 * factory mechanism.
 */
public Object create() {

	int dimensions = 3;
	Parameter dims = get(DIMENSIONS);
	if (dims != null) {
		dimensions = ((Integer)dims.getValue()).intValue();
	}
	return new Part(this, dimensions);
}


} // class PartFactory

