/*
 * @(#)AffineFinder.java
 * 
 */

package collage.kernel;

import openstar.util.*;

/**
 * Transformation finder for affine transformations.
 *
 * @version 09 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class AffineFinder implements TransFinder {

private int dim;


public AffineFinder(int dimensions) {

	dim = dimensions;
}


public Transformation findTrans(PointSequence s,
	                            PointSequence t) {
	                            
	int len[] = new int[1];
	                            
	if (! TransUtil.testPointSequences(s, t, len)) {
		return null;
	}
	
	int lenS = len[0];
	if (lenS < dim+1) {
		System.err.println("AffineFinder: Lists not n+1-testable.");
		return null;
	}
	

	//
	// Copy source sequence into matrix ms
	//
	int row, col;
	Point ps = (Point)s.getAt(0); 
	Matrix ms = new Matrix(dim+1, lenS);

	for (col = 0; col < lenS; col++) {
		for (row = 0; row < dim; row++) {
			ms.set(row, col, ps.get(row));
		}
		ms.set(dim, col, 1);
		ps = (Point)s.getAt(col+1);
	}

	//
	// Permutate the matrix columns
	//
	int[] perm = new int[lenS];
	if (! TransUtil.getLIColumnPermutation(ms, perm)) {
		return null;
	}
	TransUtil.permutateColumns(ms, perm);

	//
	// Copy target sequence into matrix mt
	//
	Point pt = (Point)t.getAt(0);
	Matrix mt = new Matrix(dim+1, lenS);

	for (col = 0; col < lenS; col++) {
		for (row = 0; row < dim; row++) {
			mt.set(row, col, pt.get(row));
		}
		mt.set(dim, col, 1);
		pt = (Point)t.getAt(col+1);
	}

	//
	// Apply the same permutations to mt
	//
	TransUtil.permutateColumns(mt, perm);

	//
	// Resize both matrices to square matrices
	//
	ms.resize(dim+1, dim+1);
	mt.resize(dim+1, dim+1);

	//
	// Find solution of m x ms = mt, which is m = mt x inv(ms)
	//
	if (! ms.invert()) {
		System.err.println("AffineFinder: Matrix not invertable.");
		return null;
	}

	//
	// Create the resulting transformation(matrix) and initialize
	// it with mt x ms
	//
	MatrixTrans result = new MatrixTrans(dim+1, dim+1);
	mt.multiply(ms, result);

	if (! TransUtil.testTransformation(s, t, result)) {
		return null;
	}
	return result; 		
}	                            


} // class AffineFinder
