/*
 * @(#)BaseElement.java
 * 
 */

package collage.kernel;

import openstar.util.*;

/**
 * Derivation base element class.
 * <p>
 * A base element describes the replacement of an <code>Edge</code> (hyperedge
 * or part) by a <code>Collage</code>, using a given <code>Transformation</code>
 * and, optionally, a given <em>context collage</em>.
 *
 * @version 14 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class BaseElement
{

private Edge target;
private Collage source;
private Transformation trans;
private Collage delContext;

public BaseElement(Edge target, 
                   Collage source,
                   Transformation trans,
                   Collage delContex) {

	this.target = target;
	this.source = source;
	this.trans = trans;
	this.delContext = delContext;
}


public Edge getTarget() {
	return target;
}

public Collage getSource() {
	return source;
}

public Transformation getTrans() {
	return trans;
}

public Collage getDelContext() {
	return delContext;
}


} // class BaseElement

