/*
 * @(#)CollageList.java
 * 
 */

package collage.kernel;

import openstar.util.*;

/**
 * A class representing a list of collages.
 * <p>
 * Objects of this class are typically used to store the result
 * of a derivation, where each derivation step yields one member
 * of the collage list.
 *
 * @version 28 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class CollageList extends TCTList
{

public CollageList() {
	
	super("collage.kernel.Collage", true);
}


/**
 * Makes a deep copy of the CollageList. All collages of the list
 * are also cloned.
 */
public Object clone() {

	CollageList newCL = new CollageList();
	copyInto(newCL);
	return newCL;
}



} // class CollageList


