/*
 * @(#)EdgeSet.java
 * 
 */

package collage.kernel;

import openstar.util.*;

/**
 * A class representing an ordered set of hyperedges.
 *
 * @version 14 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class EdgeSet extends TCTList
{

public EdgeSet() {
	
	super("collage.kernel.Edge", true);
}


/**
 * Makes a deep copy of the EdgeSet. All edges of the set
 * are also cloned.
 */
public Object clone() {

	EdgeSet newES = new EdgeSet();
	copyInto(newES);
	return newES;
}


public Edge findEqualEdge(Edge edge) {
	Edge cmp = (Edge)getAt(0);
	int i = 0;
	while (cmp != null) {
		if (cmp.equals(edge)) {
			return cmp;
		}
		cmp = (Edge)getAt(++i);
	}
	return null;
}

} // class EdgeSet


