/*
 * @(#)Grammar.java
 * 
 */

package collage.kernel;

import openstar.util.*;

/**
 * Collage grammar class.
 * <p>
 * A <code>Grammar</code> object is primarily a container for
 * two other objects, namely the <em>start collage</em>, and
 * the <em>set of rules</em>.
 *
 * @version 14 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class Grammar 
{

private Collage start;
private RuleSet rules;

public Grammar() {
	start = null;
	rules = new RuleSet();
}

public void setStart(Collage start) {
	this.start = start;
}

public Collage getStart() {
	return start;
}

public void insertRule(Rule rule) {
	rules.addElement(rule);
}

public RuleSet getRules() {
	return rules;
}	

/**
 * Normalizes the collage grammar.
 * <p>
 * This operation includes the normalization of both the
 * rules and the start collage.
 */
public void normalize(boolean transRightSide) {

	rules.normalize(transRightSide);
	rules.classifyEdges(start);
}

/**
 * <em>Not yet implemented in the Java version.</em>
 */
public void annotate() {

	// <M> not yet implemented in the Java version
}

} // class Grammar

