/*
 * @(#)Collage.java
 * 
 */

package collage.kernel;

import openstar.util.*;

/**
 * Collage rule class.
 * <p>
 * A <code>Rule</code> object is a container that groups the folling
 * pieces of information:
 * <ul>
 * <li>the label of the left-hand-side of the rule
 * <li>the collage of the right-hand-side of the rule
 * <li>optional positive and negative context collages
 * <li><em>any of</em> switches for each context collage, indicating
 * that only one part within the context must be present (not present)
 * to fulfill the context condition.
 * <li>a <em>delete</em> switch for the (positive) context collage, 
 * indicating that a matched context should be deleted. 
 * <li>a <code>TransFinder</code> object that is used to find the transformation
 * when the right-hand-side is about to replace an edge.
 * <li>a table number to which the rule is assigned. Each derivation step uses
 * only rules of one table. Rules which are assigned to table 0 are used in
 * every derivation step.
 * <li>a probability value for the rule in the range from 0 to 1
 * </ul>
 *
 * @version 14 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class Rule 
{

private String leftHandText;
private int leftHandClass;
private Collage rightHandSide;
private Collage ncontext;
private Collage context;
private boolean cAnyOf, ncAnyOf, cDelete;
private int tableNumber;
private double prob;
private TransFinder transFinder;
private String name;

public Rule(String left, 
            Collage right,
            Collage context,
            Collage ncontext,
            boolean cAnyOf,
            boolean ncAnyOf,
            boolean cDelete,
            TransFinder transFinder,
            int table,
            double prob) {
                   
	this.leftHandText = left;
	this.leftHandClass = 0;
	this.rightHandSide = right;
	this.context = context;
	this.ncontext = ncontext;
	this.cAnyOf = cAnyOf;
	this.ncAnyOf = ncAnyOf;
	this.cDelete = cDelete;
	this.transFinder = transFinder;
	this.tableNumber = table;
	this.prob = prob;                   
}



public void setText(String t) {
	leftHandText = t;
}

public String getText() {
	return leftHandText;
}

public void setEqClass(int c) {
	leftHandClass = c;
}

public int getEqClass() {
	return leftHandClass;
}

public void setName(String name) {
	this.name = name;
}

public String getName() {
	return name;
}

public Collage getRight() {
	return rightHandSide;
}

public Collage getContext() {
	return context;
}

public Collage getNContext() {
	return ncontext;
}

public boolean isCAnyOf() {
	return cAnyOf;
}

public boolean isNCAnyOf() {
	return ncAnyOf;
}

public boolean isCDelete() {
	return cDelete;
}

public int getTable() {
	return tableNumber;
}

public double getProb() {
	return prob;
}

public TransFinder getTransFinder() {
	return transFinder;
}


public Transformation findTrans(PointSequence source, 
                      PointSequence target) {
	return transFinder.findTrans(source, target);
}                      

} // class Rule

