/*
 * @(#)Table.java
 * 
 */

package collage.kernel;

import openstar.util.*;

/**
 * Derivation table class.
 * <p>
 * A derivation table is a list of <code>TableElement</code>s.
 * A table object can be queried for the next <code>TableElement</code>
 * that should be used in a derivation.
 *
 * @version 14 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class Table extends TypedList
{


public Table() {
	super("collage.kernel.TableElement", false);
}

/**
 * Inserts a new TableElement into this table.
 */
public boolean insert(TableElement te) {

	// insert sorted
	//
	TableElement cur = (TableElement)getAt(0);
	int pos = 0;
	while (cur != null) {
		if (cur.until > te.until) {
			insertElementAt(te, pos);
			return true;
		} else if (cur.until == te.until) {
			System.err.println("CollageSystem: Duplicate 'until " + cur.until + "' in derivation table.");
			return false;
		}
		cur = (TableElement)getAt(++pos);
	}
	
	// first entry or larger than all other keys
	//
	addElement(te);
	return true;
}

/**
 * Returns the next TableElement (or <code>null</code>) that should
 * be used until derivation step <code>until</code>. The first element
 * of the integer array is set to the table number of the chosen table.
 */
public TableElement nextTable(int until, int[] table) {

	TableElement cur = (TableElement)getAt(0);
	int pos = 0;
	while (cur != null && cur.until != until) {
		cur = (TableElement)getAt(++pos);
	}
	if (cur != null) {
		table[0] = cur.nextTable();
		return cur;
	}
	return null;
}


/**
 * Returns the number of derivation steps defined by the
 * TableElements of this Table. The information is stored in the
 * first element of the integer array. <code>false</code> is
 * returned in the case that the table contains no elements.
 */
public boolean getMaxUntil(int[] maxUntil) {

	int size = vector.size();
	if (size > 0) {
		TableElement last = (TableElement)getAt(size-1);
		if (last != null) {
			maxUntil[0] = last.until;
			return true;
		}
	}
	return false;
}


} // class Table




