/*
 * @(#)TableInfo.java
 * 
 */

package collage.kernel;

/**
 * TableInfo objects hold parameters for table-specific settings.
 *
 * @version 14 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class TableInfo 
{

/** The number of the table for which this objects holds information. */
protected int table;

/** Use sequential derivation (one by one)? */
protected boolean sequential;

/** Use the <em>exhausting probabilties</em> mode? */
protected boolean exhaustProb;

/** 
 * Build a derivation base (as usual), but then choose only one
 * hyperedge to replace.
 */
protected boolean oneFromBase;

public TableInfo(int table, boolean sequential, boolean exhaustProb, 
                 boolean oneFromBase) {
                 
	this.table = table;                 
	this.sequential = sequential;                 
	this.exhaustProb = exhaustProb;
	this.oneFromBase = oneFromBase;
}

public void setTable(int table) {
	this.table = table;
}

public int getTable() {
	return table;
}

public boolean isSequential() {
	return sequential;
}

public boolean isExhaustProb() {
	return exhaustProb;
}

public boolean isOneFromBase() {
	return oneFromBase;
}

} // class TableInfo

