/*
 * @(#)TableInfoList.java
 * 
 */

package collage.kernel;

import openstar.util.*;

/**
 * A class representing a list of TableInfo objects.
 *
 * @version 14 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class TableInfoList extends TCTList
{

public TableInfoList() {
	
	super("collage.kernel.TableInfo", true);
}


/**
 * Makes a deep copy of the TableInfoList. All elements are also cloned.
 */
public Object clone() {

	TableInfoList newTIL = new TableInfoList();
	copyInto(newTIL);
	return newTIL;
}

/**
 * Finds the TableInfo for a specified table. Returns null if no
 * such table is in the list.
 */
public TableInfo find(int table) {

	int size = vector.size();
	TableInfo info;
	for (int i = 0; i < size; i++) {
		info = (TableInfo)vector.elementAt(i);
		if (info.getTable() == table) {
			return info;
		}
	}
	return null;
}

} // class TableInfoList


