/*
 * @(#)TransFinder.java
 * 
 */

package collage.kernel;

import openstar.util.*;

/**
 * CollageSystem transformation finder interface.
 *
 * A transformation finder is an object that calculates a transformation
 * given two point sequences, such that one point sequence is mapped
 * to the other sequence by the transformation.
 *
 * @version 09 Apr 1997
 * @author 	Nils Schwabe
 */ 
public interface TransFinder extends Cloneable
{
	/**
	 * Creates and returns a new transformation that maps the source
	 * sequence to the dest sequence. Returns null if no such transformation
	 * could be found by this TransFinder object.
	 */
	public Transformation findTrans(PointSequence source,
	                                PointSequence dest);


} // interface TransFinder
