/* Generated By:JavaCC: Do not edit this line. CSParser.java */
package collage.parser;

import openstar.generic.*;
import openstar.util.*;
import collage.kernel.*;
import collage.generic.*;

public class CSParser implements CSParserConstants {

private Envi envi;

/**
 * Sets the environment object which contains all relevant results
 * of a global parsing process.
 * <p>
 * <em>This call is neccesary before the parser can be used.</em>
 */
public void setEnvi(Envi envi) {

         this.envi = envi;
}


/**
 * Returns the environment object which contains all relevant results
 * of a global parsing process.
 *
 * Note that many parsing functions can be used locally, i.e. without
 * relying on, or affecting, the environment object.
 */
public Envi getEnvi() {
         return envi;
}


//
// Part transformation stack
//
private final int PT_SIZE=128;
private Transformation[] ptStack = new Transformation[PT_SIZE];
private int ptInd = -1;

private void ptClearStack() {
         ptInd = -1;
         for (int i=0; i < PT_SIZE; i++) {
                 ptStack[i] = null;
         }
}

private void ptTransform(Transformable t) {
         for (int i=ptInd; i >= 0; i--) {
                 t.transform(ptStack[i]);
         }
}


private void checkParamResult(int result, String paramName) throws ParseError {
         if (result >= 0) {
                 return; // OK or only a warning
         }
         if (result == Factory.ERR_UNKNOWN_PARAMETER) {
                 envi.setErrorMsg("Unknown parameter '" + paramName + "'.");
         } else if (result == Factory.ERR_WRONG_TYPE) {
                 envi.setErrorMsg("Parameter '" + paramName + "' has an invalid type.");
         } else {
                 envi.setErrorMsg("Unknown error for parameter '" + paramName + "'.");
         }
         throw new ParseError();
}

/**
 * The main function may be used to test this parser as an external
 * program. However, the results of the parsing process are lost since
 * there is no way of storing the result in a file or something similar.
 * Therefore, this entry point is only useful for testing purposes.
 */
public static void main(String args[]) {

         CSParser parser;

         if (args.length == 0) {
                 System.out.println("CollageSystem Parser:  Reading from standard input . . .");
                 parser = new CSParser(new java.io.DataInputStream(System.in));
                 parser.setEnvi(new Envi());
    } else if (args.length == 1) {
                 System.out.println("CollageSystem Parser:  Reading from file " + args[0] + " . . .");
                 try {
                         parser = new CSParser(new java.io.DataInputStream(new java.io.FileInputStream(args[0])));
                         parser.setEnvi(new Envi());
                 } catch (java.io.FileNotFoundException e) {
                         System.out.println("CollageSystem Parser:  File " + args[0] + " not found.");
                         return;
                 }
         } else {
                 System.out.println("CollageSystem Parser:  Usage is one of:");
                 System.out.println("         java collage.parser.CSParser < inputfile");
                 System.out.println("OR");
                 System.out.println("         java collage.parser.CSParser inputfile");
                 return;
         }

         try {
                 parser.ParseCollageGrammar();
                 System.out.println("CollageSystem Parser:  Grammar parsed successfully.");
         } catch (ParseError e) {
                 System.out.println("CollageSystem Parser:  Encountered errors during parse.");
         }
}

//-----------------------------------------------------------------------------
//-----	Beginning of the parser -----------------------------------------------
//-----------------------------------------------------------------------------

/** 
 * Parses a complete collage grammar.
 * <p>
 * Results are stored in the <code>envi</code> member of this parser.
 */
  final public void ParseCollageGrammar() throws ParseError {
    label_1:
    while (true) {
      if (jj_mask_0[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[0] = jj_gen;
        break label_1;
      }
      ParseOption();
    }
    ParseGrammar(envi.getGrammar());
    ParseDerivation(envi.getTable());
         envi.getGrammar().normalize(false);
    jj_consume_token(0);
  }

  static boolean[] jj_mask_0 = new boolean[91];
  static {
    jj_mask_0[DISPLAY] =
    jj_mask_0[SET] =
    jj_mask_0[LBRACE] = true;
  }
  
/**
 * Parses an arbitrary option.
 * <p>
 * Results are stored in the <code>envi</code> member of this parser.
 */
  final public void ParseOption() throws ParseError {
         String ident;
         Number aNumber;
         String aString;
         Boolean aBoolean;
         Point aPoint;
         DisplayFactory displayFactory = null;
         PointSequence aPS;
         Edge anEdge;
    if (jj_mask_8[getToken(1).kind]) {
      jj_consume_token(SET);
      ident = ParseIdentifier();
      jj_consume_token(ASSIGN);
      if (jj_2_2(2147483647)) {
                         aPS = new PointSequence();
        ParsePoints(aPS);
                         envi.getParamSet().put(ident, aPS);
      } else {
        if (jj_2_1(2147483647)) {
          aPoint = ParsePoint();
                         envi.getParamSet().put(ident, aPoint);
        } else {
          if (jj_mask_7[getToken(1).kind]) {
            aNumber = ParseNumber();
                         envi.getParamSet().put(ident, aNumber);
          } else {
            jj_expLA1[7] = jj_gen;
            if (jj_mask_6[getToken(1).kind]) {
              aString = ParseString();
                         envi.getParamSet().put(ident, aString);
            } else {
              jj_expLA1[6] = jj_gen;
              if (jj_mask_5[getToken(1).kind]) {
                aBoolean = ParseBoolean();
                         envi.getParamSet().put(ident, aBoolean);
              } else {
                jj_expLA1[5] = jj_gen;
                if (jj_mask_4[getToken(1).kind]) {
                  anEdge = ParsePart(null);
                         envi.getParamSet().put(ident, anEdge);
                } else {
                  jj_expLA1[4] = jj_gen;
                  if (jj_mask_3[getToken(1).kind]) {
                    anEdge = ParseEdge(null);
                         envi.getParamSet().put(ident, anEdge);
                  } else {
                    jj_expLA1[3] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseError();
                  }
                }
              }
            }
          }
        }
      }
    } else {
      jj_expLA1[8] = jj_gen;
      if (jj_mask_2[getToken(1).kind]) {
        jj_consume_token(DISPLAY);
        ident = ParseIdentifier();
                 int[] error = new int[1];
                 Factory factory = Factory.getFactory(ident, error);
                 if (factory == null) {
                         if (error[0] == Factory.ERR_CLASS_NOT_FOUND) {
                                 envi.setErrorMsg("Display factory class '" + ident + "Factory' doesn't exist.");
                         } else if (error[0] == Factory.ERR_INSTANCE_ERROR) {
                                 envi.setErrorMsg("Couldn't instantiate '" + ident + "Factory' object.");
                         } else if (error[0] == Factory.ERR_NOT_A_FACTORY) {
                                 envi.setErrorMsg("The class '" + ident + "Factory' is not a factory.");
                         } else {
                                 envi.setErrorMsg("Unknown factory error for '" + ident + "'.");
                         }
                         throw new ParseError();
                 }
                 if (! (factory instanceof DisplayFactory)) {
                         envi.setErrorMsg("Factory '" + ident + "' is not a DisplayFactory.");
                         throw new ParseError();
                 }
                 displayFactory = (DisplayFactory)factory;
        ParseParameters(displayFactory);
                 String[] missingParams = displayFactory.missingParams();
                 if (missingParams != null) {
                         envi.setErrorMsg("Display '" + ident + "' requires more parameters:\n" + missingParams.toString());
                         throw new ParseError();
                 } else {
                         Display newDisplay = (Display)displayFactory.create();
                         envi.getDisplays().addElement(newDisplay);
                 }
      } else {
        jj_expLA1[2] = jj_gen;
        if (jj_mask_1[getToken(1).kind]) {
          PtOperation();
        } else {
          jj_expLA1[1] = jj_gen;
          jj_consume_token(-1);
          throw new ParseError();
        }
      }
    }
  }

  static boolean[] jj_mask_1 = new boolean[91];
  static {
    jj_mask_1[LBRACE] = true;
  }
  static boolean[] jj_mask_2 = new boolean[91];
  static {
    jj_mask_2[DISPLAY] = true;
  }
  static boolean[] jj_mask_3 = new boolean[91];
  static {
    jj_mask_3[EDGE] = true;
  }
  static boolean[] jj_mask_4 = new boolean[91];
  static {
    jj_mask_4[PART] = true;
  }
  static boolean[] jj_mask_5 = new boolean[91];
  static {
    jj_mask_5[BOOL_TRUE] =
    jj_mask_5[BOOL_FALSE] = true;
  }
  static boolean[] jj_mask_6 = new boolean[91];
  static {
    jj_mask_6[STRING_LITERAL] = true;
  }
  static boolean[] jj_mask_7 = new boolean[91];
  static {
    jj_mask_7[INTEGER_LITERAL] =
    jj_mask_7[FLOATING_POINT_LITERAL] =
    jj_mask_7[LPAREN] =
    jj_mask_7[SIN] =
    jj_mask_7[COS] =
    jj_mask_7[TAN] =
    jj_mask_7[ASIN] =
    jj_mask_7[ACOS] =
    jj_mask_7[ATAN] =
    jj_mask_7[SQRT] =
    jj_mask_7[LOG] =
    jj_mask_7[EXP] =
    jj_mask_7[POWER] =
    jj_mask_7[MIN] =
    jj_mask_7[MAX] =
    jj_mask_7[RANDOM] =
    jj_mask_7[ABS] =
    jj_mask_7[EULER] =
    jj_mask_7[PI] =
    jj_mask_7[FLOOR] =
    jj_mask_7[CEIL] =
    jj_mask_7[RINT] =
    jj_mask_7[ATAN2] =
    jj_mask_7[RAD] =
    jj_mask_7[IDENTIFIER] = true;
  }
  static boolean[] jj_mask_8 = new boolean[91];
  static {
    jj_mask_8[SET] = true;
  }
  
/**
 * Parses the grammar part, not including parameters or derivation
 * specification, into a given <code>Grammar</code> object.
 */
  final public void ParseGrammar(Grammar cg) throws ParseError {
         Collage start;
    jj_consume_token(GRAMMAR);
    start = ParseStartCollage();
                 cg.setStart(start);
    label_2:
    while (true) {
      if (jj_mask_9[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[9] = jj_gen;
        break label_2;
      }
      ParseRule(cg.getRules());
    }
  }

  static boolean[] jj_mask_9 = new boolean[91];
  static {
    jj_mask_9[RULE] = true;
  }
  
/**
 * Parses the start collage.
 * <p>
 * Returns the parsed Collage.
 */
  final public Collage ParseStartCollage() throws ParseError {
         Collage start;
    jj_consume_token(START);
    start = ParseCollage();
                 return start;
  }

/**
 * Parses a single collage.
 * <p>
 * Returns the new collage.
 */
  final public Collage ParseCollage() throws ParseError {
         PointSequence pins = new PointSequence();
         EdgeSet edges = new EdgeSet();
         Collage collage = new Collage(pins, edges);
    label_3:
    while (true) {
      if (jj_mask_10[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[10] = jj_gen;
        break label_3;
      }
      ParseCollageElement(collage);
    }
    jj_consume_token(ENDCOLLAGE);
                 return collage;
  }

  static boolean[] jj_mask_10 = new boolean[91];
  static {
    jj_mask_10[PINS] =
    jj_mask_10[EDGE] =
    jj_mask_10[PART] =
    jj_mask_10[LBRACE] = true;
  }
  
/**
 * Parses one arbitrary element into a given collage. 
 * <p>
 * Elements of a collage are pin-points, parts and edges.
 */
  final public void ParseCollageElement(Collage collage) throws ParseError {
    if (jj_mask_14[getToken(1).kind]) {
      ParsePins(collage.getPins());
    } else {
      jj_expLA1[14] = jj_gen;
      if (jj_mask_13[getToken(1).kind]) {
        ParsePart(collage.getEdges());
      } else {
        jj_expLA1[13] = jj_gen;
        if (jj_mask_12[getToken(1).kind]) {
          ParseEdge(collage.getEdges());
        } else {
          jj_expLA1[12] = jj_gen;
          if (jj_mask_11[getToken(1).kind]) {
            PtOperation();
          } else {
            jj_expLA1[11] = jj_gen;
            jj_consume_token(-1);
            throw new ParseError();
          }
        }
      }
    }
  }

  static boolean[] jj_mask_11 = new boolean[91];
  static {
    jj_mask_11[LBRACE] = true;
  }
  static boolean[] jj_mask_12 = new boolean[91];
  static {
    jj_mask_12[EDGE] = true;
  }
  static boolean[] jj_mask_13 = new boolean[91];
  static {
    jj_mask_13[PART] = true;
  }
  static boolean[] jj_mask_14 = new boolean[91];
  static {
    jj_mask_14[PINS] = true;
  }
  
/**
 * Parses pin-points into a given PointSequence object.
 */
  final public void ParsePins(PointSequence pins) throws ParseError {
    jj_consume_token(PINS);
    ParsePoints(pins);
                 ptTransform(pins);
  }

/**
 * Parses a single "part".
 * <p>
 * If the <code>EdgeSet</code> parameter is not <code>null</code>
 * then the new part will be added to the set.
 * @return The parsed part
 */
  final public Edge ParsePart(EdgeSet edges) throws ParseError {
         String partClassName = null;
         String label = null;
         PartFactory partFactory;
         String pcn = null;
         Token s;
         Edge newPart;
    jj_consume_token(PART);
    if (jj_mask_15[getToken(1).kind]) {
      PtOperation();
    } else {
      jj_expLA1[15] = jj_gen;
      ;
    }
    if (jj_2_3(2147483647)) {
      label = ParseLabel();
      partClassName = ParseIdentifier();
                         if (partClassName != null) {
                                 pcn = partClassName;
                         } else {
                                 pcn = "collage.generic.Part";
                         }
                         int[] error = new int[1];
                         Factory factory = Factory.getFactory(pcn, error);
                         if (factory == null) {
                                 if (error[0] == Factory.ERR_CLASS_NOT_FOUND) {
                                         envi.setErrorMsg("Part factory class '" + pcn + "Factory' doesn't exist.");
                                 } else if (error[0] == Factory.ERR_INSTANCE_ERROR) {
                                         envi.setErrorMsg("Couldn't instantiate '" + pcn + "Factory' object.");
                                 } else if (error[0] == Factory.ERR_NOT_A_FACTORY) {
                                         envi.setErrorMsg("The class '" + pcn + "Factory' is not a factory.");
                                 } else {
                                         envi.setErrorMsg("Unknown factory error for '" + pcn + "'.");
                                 }
                                 throw new ParseError();
                         }
                         if (! (factory instanceof PartFactory)) {
                                 envi.setErrorMsg("Factory '" + pcn + "' is not a PartFactory.");
                                 throw new ParseError();
                         }
                         partFactory = (PartFactory)factory;
      ParseParameters(partFactory);
                         String[] missingParams = partFactory.missingParams();
                         if (missingParams != null) {
                                 envi.setErrorMsg("Part '" + pcn + "' requires more parameters:\n" + missingParams.toString());
                                 throw new ParseError();
                         } else {
                                 newPart = (Edge)partFactory.create();
                         }
    } else {
      if (jj_mask_16[getToken(1).kind]) {
        s = jj_consume_token(IDENTIFIER);
                         // Lookup in the parameters if the identifier is defined there
                         Parameter param = envi.getParamSet().get(s.image);
                         if (param == null) {
                                 envi.setErrorMsg("Undefined parameter '" + s.image + "' in Part specification.");
                                 throw new ParseError();
                         } else {
                                 Object value = param.getValue();
                                 if (! (value instanceof Edge)) {
                                         envi.setErrorMsg("Parameter '" + s.image + "' is not an Edge or Part.");
                                         throw new ParseError();
                                 }
                                 newPart = (Edge)((Edge)value).clone();
                         }
      } else {
        jj_expLA1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseError();
      }
    }
                 if (label != null) {
                         newPart.setLabel(label);
                 }
                 if (edges != null) {
                         edges.addElement(newPart);
                 }
                 ptTransform(newPart);
    if (jj_mask_17[getToken(1).kind]) {
      PtOperation();
    } else {
      jj_expLA1[17] = jj_gen;
      ;
    }
                 return newPart;
  }

  static boolean[] jj_mask_15 = new boolean[91];
  static {
    jj_mask_15[LBRACE] = true;
  }
  static boolean[] jj_mask_16 = new boolean[91];
  static {
    jj_mask_16[IDENTIFIER] = true;
  }
  static boolean[] jj_mask_17 = new boolean[91];
  static {
    jj_mask_17[LBRACE] = true;
  }
  
  final public void ParseParameters(Factory factory) throws ParseError {
    jj_consume_token(LPAREN);
    label_4:
    while (true) {
      if (jj_mask_18[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[18] = jj_gen;
        break label_4;
      }
      ParseParameter(factory);
    }
    jj_consume_token(RPAREN);
  }

  static boolean[] jj_mask_18 = new boolean[91];
  static {
    jj_mask_18[IDENTIFIER] = true;
  }
  
  final public void ParseParameter(Factory factory) throws ParseError {
         String paraName;
         Point aPoint;
         Number aNumber;
         String aString;
         PointSequence aPS;
    paraName = ParseIdentifier();
    jj_consume_token(ASSIGN);
    if (jj_2_5(2147483647)) {
                         aPS = new PointSequence();
      ParsePoints(aPS);
                         checkParamResult(factory.newParam(paraName, aPS), paraName);
    } else {
      if (jj_2_4(2147483647)) {
        aPoint = ParsePoint();
                         checkParamResult(factory.newParam(paraName, aPoint), paraName);
      } else {
        if (jj_mask_20[getToken(1).kind]) {
          aNumber = ParseNumber();
                         checkParamResult(factory.newParam(paraName, aNumber), paraName);
        } else {
          jj_expLA1[20] = jj_gen;
          if (jj_mask_19[getToken(1).kind]) {
            aString = ParseString();
                         checkParamResult(factory.newParam(paraName, aString), paraName);
          } else {
            jj_expLA1[19] = jj_gen;
            jj_consume_token(-1);
            throw new ParseError();
          }
        }
      }
    }
  }

  static boolean[] jj_mask_19 = new boolean[91];
  static {
    jj_mask_19[STRING_LITERAL] = true;
  }
  static boolean[] jj_mask_20 = new boolean[91];
  static {
    jj_mask_20[INTEGER_LITERAL] =
    jj_mask_20[FLOATING_POINT_LITERAL] =
    jj_mask_20[LPAREN] =
    jj_mask_20[SIN] =
    jj_mask_20[COS] =
    jj_mask_20[TAN] =
    jj_mask_20[ASIN] =
    jj_mask_20[ACOS] =
    jj_mask_20[ATAN] =
    jj_mask_20[SQRT] =
    jj_mask_20[LOG] =
    jj_mask_20[EXP] =
    jj_mask_20[POWER] =
    jj_mask_20[MIN] =
    jj_mask_20[MAX] =
    jj_mask_20[RANDOM] =
    jj_mask_20[ABS] =
    jj_mask_20[EULER] =
    jj_mask_20[PI] =
    jj_mask_20[FLOOR] =
    jj_mask_20[CEIL] =
    jj_mask_20[RINT] =
    jj_mask_20[ATAN2] =
    jj_mask_20[RAD] =
    jj_mask_20[IDENTIFIER] = true;
  }
  
/**
 * Parses a single <code>Hyperedge</code>.
 * <p>
 * If the <code>EdgeSet</code> parameter is not <code>null</code>
 * then the new part will be added to the set.
 * <p>
 * Note that the <code>Hyperedge</code> class, which is a subclass of 
 * the abstract class <code>Edge</code>, is the only edge class directly
 * known by the kernel, and thus does not require the presence of additional 
 * implementation classes.
 */
  final public Edge ParseEdge(EdgeSet edges) throws ParseError {
         String label;
         Edge edge;
         Token s;
    jj_consume_token(EDGE);
    if (jj_mask_21[getToken(1).kind]) {
      PtOperation();
    } else {
      jj_expLA1[21] = jj_gen;
      ;
    }
    if (jj_2_6(2147483647)) {
      label = ParseLabel();
                         edge = new Hyperedge(label);
      ParsePoints(((Hyperedge)edge).getAttachedPoints());
    } else {
      if (jj_mask_22[getToken(1).kind]) {
        s = jj_consume_token(IDENTIFIER);
                         // Lookup in the parameters if the identifier is defined there
                         Parameter param = envi.getParamSet().get(s.image);
                         if (param == null) {
                                 envi.setErrorMsg("Undefined parameter '" + s.image + "' in Edge specification.");
                                 throw new ParseError();
                         } else {
                                 Object value = param.getValue();
                                 if (! (value instanceof Edge)) {
                                         envi.setErrorMsg("Parameter '" + s.image + "' is not an Edge or Part.");
                                         throw new ParseError();
                                 }
                                 edge = (Edge)((Edge)value).clone();
                         }
      } else {
        jj_expLA1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseError();
      }
    }
                 if (edges != null) {
                         edges.addElement(edge);
                 }
                 ptTransform(edge);
    if (jj_mask_23[getToken(1).kind]) {
      PtOperation();
    } else {
      jj_expLA1[23] = jj_gen;
      ;
    }
                 return edge;
  }

  static boolean[] jj_mask_21 = new boolean[91];
  static {
    jj_mask_21[LBRACE] = true;
  }
  static boolean[] jj_mask_22 = new boolean[91];
  static {
    jj_mask_22[IDENTIFIER] = true;
  }
  static boolean[] jj_mask_23 = new boolean[91];
  static {
    jj_mask_23[LBRACE] = true;
  }
  
/**
 * Parses a single rule into a given RuleSet object.
 */
  final public void ParseRule(RuleSet ruleSet) throws ParseError {
         String name = null;
         String label;
         double prob = 1.0;
         Collage rightHand;
         Collage pContext = null;
         boolean pAnyOf = false, pDelContext = false;
         Collage nContext = null;
         boolean nAnyOf = false;
         Number table = null;
         Parameter dims = envi.getParamSet().get("dimensions");
         TransFinder transFinder = new AffineFinder(((Integer)dims.getValue()).intValue());
    jj_consume_token(RULE);
    if (jj_mask_24[getToken(1).kind]) {
      jj_consume_token(LBRACKET);
      name = ParseLabel();
      jj_consume_token(RBRACKET);
    } else {
      jj_expLA1[24] = jj_gen;
      ;
    }
    label = ParseLabel();
    if (jj_mask_25[getToken(1).kind]) {
      prob = ParseRuleProb();
    } else {
      jj_expLA1[25] = jj_gen;
      ;
    }
    rightHand = ParseCollage();
    if (jj_mask_28[getToken(1).kind]) {
      jj_consume_token(CONTEXT);
      if (jj_mask_26[getToken(1).kind]) {
        pAnyOf = ParseAnyOf();
      } else {
        jj_expLA1[26] = jj_gen;
        ;
      }
      if (jj_mask_27[getToken(1).kind]) {
        pDelContext = ParseDelete();
      } else {
        jj_expLA1[27] = jj_gen;
        ;
      }
      pContext = ParseCollage();
    } else {
      jj_expLA1[28] = jj_gen;
      ;
    }
    if (jj_mask_30[getToken(1).kind]) {
      jj_consume_token(NEGATIVE);
      jj_consume_token(CONTEXT);
      if (jj_mask_29[getToken(1).kind]) {
        nAnyOf = ParseAnyOf();
      } else {
        jj_expLA1[29] = jj_gen;
        ;
      }
      nContext = ParseCollage();
    } else {
      jj_expLA1[30] = jj_gen;
      ;
    }
    if (jj_mask_31[getToken(1).kind]) {
      jj_consume_token(TABLE);
      table = ParseNumber();
    } else {
      jj_expLA1[31] = jj_gen;
      ;
    }
                 int tab;
                 if (table == null) {
                         tab = 0;
                 } else {
                         tab = table.intValue();
                 }
                 Rule rule = new Rule(label, rightHand, pContext, nContext,
                                      pAnyOf, nAnyOf, pDelContext,
                                      transFinder, tab, prob);
                 if (name != null) {
                         rule.setName(name);
                 }
                 ruleSet.addElement(rule);
  }

  static boolean[] jj_mask_24 = new boolean[91];
  static {
    jj_mask_24[LBRACKET] = true;
  }
  static boolean[] jj_mask_25 = new boolean[91];
  static {
    jj_mask_25[PROB] = true;
  }
  static boolean[] jj_mask_26 = new boolean[91];
  static {
    jj_mask_26[ANY] = true;
  }
  static boolean[] jj_mask_27 = new boolean[91];
  static {
    jj_mask_27[DELETE] = true;
  }
  static boolean[] jj_mask_28 = new boolean[91];
  static {
    jj_mask_28[CONTEXT] = true;
  }
  static boolean[] jj_mask_29 = new boolean[91];
  static {
    jj_mask_29[ANY] = true;
  }
  static boolean[] jj_mask_30 = new boolean[91];
  static {
    jj_mask_30[NEGATIVE] = true;
  }
  static boolean[] jj_mask_31 = new boolean[91];
  static {
    jj_mask_31[TABLE] = true;
  }
  
  final public double ParseRuleProb() throws ParseError {
         Number prob;
    jj_consume_token(PROB);
    prob = ParseNumber();
                 return prob.doubleValue();
  }

  final public boolean ParseAnyOf() throws ParseError {
    jj_consume_token(ANY);
    jj_consume_token(OF);
          return true;
  }

  final public boolean ParseDelete() throws ParseError {
    jj_consume_token(DELETE);
          return true;
  }

  final public void ParsePoints(PointSequence ps) throws ParseError {
         Point point;
         int operation = 0;
    jj_consume_token(LBRACKET);
    ParsePointsTerm(ps);
    if (jj_mask_36[getToken(1).kind]) {
      if (jj_mask_35[getToken(1).kind]) {
        jj_consume_token(PLUS);
                                          operation = 1;
      } else {
        jj_expLA1[35] = jj_gen;
        if (jj_mask_34[getToken(1).kind]) {
          jj_consume_token(MINUS);
                                          operation = 2;
        } else {
          jj_expLA1[34] = jj_gen;
          if (jj_mask_33[getToken(1).kind]) {
            jj_consume_token(STAR);
                                          operation = 3;
          } else {
            jj_expLA1[33] = jj_gen;
            if (jj_mask_32[getToken(1).kind]) {
              jj_consume_token(SLASH);
                                          operation = 4;
            } else {
              jj_expLA1[32] = jj_gen;
              jj_consume_token(-1);
              throw new ParseError();
            }
          }
        }
      }
      point = ParsePointTerm();
                         int dimP = point.getDim();
                         Point seqP = (Point)ps.getAt(0);
                         int p = 0;
                         while (seqP != null) {
                                 int dimSP = seqP.getDim();
                                 if (dimP != dimSP) {
                                         envi.setErrorMsg("Incompatible point operands: "+point+", "+seqP);
                                         throw new ParseError();
                                 }
                                 for (int i=0; i < dimP; i++) {
                                         switch (operation) {
                                         case 1: seqP.set(i, seqP.get(i)+point.get(i)); break;
                                         case 2: seqP.set(i, seqP.get(i)-point.get(i)); break;
                                         case 3: seqP.set(i, seqP.get(i)*point.get(i)); break;
                                         case 4: seqP.set(i, seqP.get(i)/point.get(i)); break;
                                         }
                                 }
                                 seqP = (Point)ps.getAt(++p);
                         }
    } else {
      jj_expLA1[36] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
  }

  static boolean[] jj_mask_32 = new boolean[91];
  static {
    jj_mask_32[SLASH] = true;
  }
  static boolean[] jj_mask_33 = new boolean[91];
  static {
    jj_mask_33[STAR] = true;
  }
  static boolean[] jj_mask_34 = new boolean[91];
  static {
    jj_mask_34[MINUS] = true;
  }
  static boolean[] jj_mask_35 = new boolean[91];
  static {
    jj_mask_35[PLUS] = true;
  }
  static boolean[] jj_mask_36 = new boolean[91];
  static {
    jj_mask_36[PLUS] =
    jj_mask_36[MINUS] =
    jj_mask_36[STAR] =
    jj_mask_36[SLASH] = true;
  }
  
  final public void ParsePointsTerm(PointSequence ps) throws ParseError {
         Token s;
    if (jj_2_7(2147483647)) {
      AddPoint(ps);
      label_5:
      while (true) {
        AddPoint(ps);
        if (jj_mask_38[getToken(1).kind]) {
          ;
        } else {
          jj_expLA1[38] = jj_gen;
          break label_5;
        }
      }
    } else {
      if (jj_mask_37[getToken(1).kind]) {
        s = jj_consume_token(IDENTIFIER);
                 // Lookup in the parameters if the identifier is defined there
                 Parameter param = envi.getParamSet().get(s.image);
                 if (param == null) {
                         envi.setErrorMsg("Undefined parameter '" + s.image + "' in Point sequence specification.");
                         throw new ParseError();
                 } else {
                         Object value = param.getValue();
                         if (! (value instanceof PointSequence)) {
                                 envi.setErrorMsg("Parameter '" + s.image + "' is not a Point sequence.");
                                 throw new ParseError();
                         }
                         // copy all points into 'ps':
                         PointSequence orgPS = (PointSequence)value;
                         Point p = (Point)orgPS.getAt(0);
                         int i = 0;
                         while (p != null) {
                                 ps.addElement(p.clone());
                                 p = (Point)orgPS.getAt(++i);
                         }
                 }
      } else {
        jj_expLA1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseError();
      }
    }
  }

  static boolean[] jj_mask_37 = new boolean[91];
  static {
    jj_mask_37[IDENTIFIER] = true;
  }
  static boolean[] jj_mask_38 = new boolean[91];
  static {
    jj_mask_38[LPAREN] =
    jj_mask_38[IDENTIFIER] = true;
  }
  
  final public void AddPoint(PointSequence ps) throws ParseError {
         Point p;
    p = ParsePoint();
                 ps.addElement(p);
  }

  final public Point ParsePoint() throws ParseError {
         Point p1, p2;
         Number x;
    if (jj_2_11(2147483647)) {
      jj_consume_token(LPAREN);
      p1 = ParsePointTerm();
      jj_consume_token(PLUS);
      p2 = ParsePointTerm();
      jj_consume_token(RPAREN);
                 int dim1 = p1.getDim();
                 int dim2 = p2.getDim();
                 if (dim1 != dim2) {
                         envi.setErrorMsg("Incompatible point operands: "+p1+", "+p2);
                         throw new ParseError();
                 }
                 for (int i=0; i < dim1; i++) {
                         p1.set(i, p1.get(i)+p2.get(i));
                 }
                 return p1;
    } else {
      if (jj_2_10(2147483647)) {
        jj_consume_token(LPAREN);
        p1 = ParsePointTerm();
        jj_consume_token(MINUS);
        p2 = ParsePointTerm();
        jj_consume_token(RPAREN);
                 int dim1 = p1.getDim();
                 int dim2 = p2.getDim();
                 if (dim1 != dim2) {
                         envi.setErrorMsg("Incompatible point operands: "+p1+", "+p2);
                         throw new ParseError();
                 }
                 for (int i=0; i < dim1; i++) {
                         p1.set(i, p1.get(i)-p2.get(i));
                 }
                 return p1;
      } else {
        if (jj_2_9(2147483647)) {
          jj_consume_token(LPAREN);
          p1 = ParsePointTerm();
          jj_consume_token(STAR);
          p2 = ParsePointTerm();
          jj_consume_token(RPAREN);
                 int dim1 = p1.getDim();
                 int dim2 = p2.getDim();
                 if (dim1 != dim2) {
                         envi.setErrorMsg("Incompatible point operands: "+p1+", "+p2);
                         throw new ParseError();
                 }
                 for (int i=0; i < dim1; i++) {
                         p1.set(i, p1.get(i)*p2.get(i));
                 }
                 return p1;
        } else {
          if (jj_2_8(2147483647)) {
            jj_consume_token(LPAREN);
            p1 = ParsePointTerm();
            jj_consume_token(STAR);
            p2 = ParsePointTerm();
            jj_consume_token(RPAREN);
                 int dim1 = p1.getDim();
                 int dim2 = p2.getDim();
                 if (dim1 != dim2) {
                         envi.setErrorMsg("Incompatible point operands: "+p1+", "+p2);
                         throw new ParseError();
                 }
                 for (int i=0; i < dim1; i++) {
                         p1.set(i, p1.get(i)/p2.get(i));
                 }
                 return p1;
          } else {
            if (jj_mask_39[getToken(1).kind]) {
              p1 = ParsePointTerm();
                 return p1;
            } else {
              jj_expLA1[39] = jj_gen;
              jj_consume_token(-1);
              throw new ParseError();
            }
          }
        }
      }
    }
  }

  static boolean[] jj_mask_39 = new boolean[91];
  static {
    jj_mask_39[LPAREN] =
    jj_mask_39[IDENTIFIER] = true;
  }
  
  final public Point ParsePointTerm() throws ParseError {
         Token s;
         Number x, y, z;
    if (jj_mask_43[getToken(1).kind]) {
      jj_consume_token(LPAREN);
      x = ParseNumber();
      jj_consume_token(COMMA);
      y = ParseNumber();
      if (jj_mask_42[getToken(1).kind]) {
        jj_consume_token(RPAREN);
                         return new Point(x.doubleValue(),y.doubleValue());
      } else {
        jj_expLA1[42] = jj_gen;
        if (jj_mask_41[getToken(1).kind]) {
          jj_consume_token(COMMA);
          z = ParseNumber();
          jj_consume_token(RPAREN);
                         return new Point(x.doubleValue(), y.doubleValue(), z.doubleValue());
        } else {
          jj_expLA1[41] = jj_gen;
          jj_consume_token(-1);
          throw new ParseError();
        }
      }
    } else {
      jj_expLA1[43] = jj_gen;
      if (jj_mask_40[getToken(1).kind]) {
        s = jj_consume_token(IDENTIFIER);
                 // Lookup in the parameters if the identifier is defined there
                 Parameter param = envi.getParamSet().get(s.image);
                 if (param == null) {
                         envi.setErrorMsg("Undefined parameter '" + s.image + "' in Point specification.");
                         throw new ParseError();
                 } else {
                         Object value = param.getValue();
                         if (! (value instanceof Point)) {
                                 envi.setErrorMsg("Parameter '" + s.image + "' is not a Point.");
                                 throw new ParseError();
                         }
                         return (Point)((Point)value).clone();
                 }
      } else {
        jj_expLA1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseError();
      }
    }
  }

  static boolean[] jj_mask_40 = new boolean[91];
  static {
    jj_mask_40[IDENTIFIER] = true;
  }
  static boolean[] jj_mask_41 = new boolean[91];
  static {
    jj_mask_41[COMMA] = true;
  }
  static boolean[] jj_mask_42 = new boolean[91];
  static {
    jj_mask_42[RPAREN] = true;
  }
  static boolean[] jj_mask_43 = new boolean[91];
  static {
    jj_mask_43[LPAREN] = true;
  }
  
/**
 * Parses a derivation specification in a given Table object.
 */
  final public void ParseDerivation(Table table) throws ParseError {
    jj_consume_token(DERIVATION);
    label_6:
    while (true) {
      if (jj_mask_44[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[44] = jj_gen;
        break label_6;
      }
      ParseDerivEntry(table);
    }
  }

  static boolean[] jj_mask_44 = new boolean[91];
  static {
    jj_mask_44[UNTIL] = true;
  }
  
/**
 * Parses a single derivation entry into a given Table object.
 */
  final public void ParseDerivEntry(Table table) throws ParseError {
         Number until, tnum;
    jj_consume_token(UNTIL);
    until = ParseNumber();
    jj_consume_token(DO);
    tnum = ParseNumber();
                 TableElement tableElem = new TableElement(until.intValue());
                 TableElemEntry entry = new TableElemEntry(1, tnum.intValue());
                 tableElem.addElement(entry);
                 table.insert(tableElem);
  }

//--------------------------------------------------------------------
//-----	General parsing methods --------------------------------------
//--------------------------------------------------------------------
  final public void PtOperation() throws ParseError {
    jj_consume_token(LBRACE);
    label_7:
    while (true) {
      if (jj_mask_45[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[45] = jj_gen;
        break label_7;
      }
      if (jj_mask_47[getToken(1).kind]) {
        jj_consume_token(PUSH);
                         ptInd++;
                         if (ptInd >= PT_SIZE) {
                                 envi.setErrorMsg("Transformation stack overflow.");
                                 throw new ParseError();
                         }
        NewPartTrans();
      } else {
        jj_expLA1[47] = jj_gen;
        if (jj_mask_46[getToken(1).kind]) {
          jj_consume_token(POP);
                         if (ptInd < 0) {
                                 envi.setErrorMsg("POP on empty transformation stack.");
                                 throw new ParseError();
                         }
                         ptStack[ptInd--] = null;
        } else {
          jj_expLA1[46] = jj_gen;
          jj_consume_token(-1);
          throw new ParseError();
        }
      }
    }
    jj_consume_token(RBRACE);
  }

  static boolean[] jj_mask_45 = new boolean[91];
  static {
    jj_mask_45[PUSH] =
    jj_mask_45[POP] = true;
  }
  static boolean[] jj_mask_46 = new boolean[91];
  static {
    jj_mask_46[POP] = true;
  }
  static boolean[] jj_mask_47 = new boolean[91];
  static {
    jj_mask_47[PUSH] = true;
  }
  
  final public void NewPartTrans() throws ParseError {
         PointSequence p1, p2;
         Point p = null;
         Number angle;
    if (jj_mask_52[getToken(1).kind]) {
      jj_consume_token(MAP);
                 p1 = new PointSequence();
                 p2 = new PointSequence();
      ParsePoints(p1);
      jj_consume_token(TO);
      ParsePoints(p2);
                 Parameter dims = envi.getParamSet().get("dimensions");
                 TransFinder transFinder = new AffineFinder(((Integer)dims.getValue()).intValue());
                 Transformation t = transFinder.findTrans(p1, p2);
                 if (t == null) {
                         envi.setErrorMsg("No affine mapping from "+p1+" to "+p2);
                         throw new ParseError();
                 }
                 ptStack[ptInd] = t;
    } else {
      jj_expLA1[52] = jj_gen;
      if (jj_mask_51[getToken(1).kind]) {
        jj_consume_token(TRANSLATE);
        p = ParsePoint();
                 Parameter dims = envi.getParamSet().get("dimensions");
                 int d = ((Integer)dims.getValue()).intValue();
                 if (d == 2) {
                         MatrixTrans trans = new MatrixTrans(3,3);

                         trans.set(0, 0, 1.0);
                         trans.set(0, 1, 0.0);
                         trans.set(0, 2, p.get(0));

                         trans.set(1, 0, 0.0);
                         trans.set(1, 1, 1.0);
                         trans.set(1, 2, p.get(1));

                         trans.set(2, 0, 0.0);
                         trans.set(2, 1, 0.0);
                         trans.set(2, 2, 1.0);

                         ptStack[ptInd] = trans;
                 } else if (d == 3) {
                         MatrixTrans trans = new MatrixTrans(4,4);

                         trans.set(0, 0, 1.0);
                         trans.set(0, 1, 0.0);
                         trans.set(0, 2, 0.0);
                         trans.set(0, 3, p.get(0));

                         trans.set(1, 0, 0.0);
                         trans.set(1, 1, 1.0);
                         trans.set(1, 2, 0.0);
                         trans.set(1, 3, p.get(1));

                         trans.set(2, 0, 0.0);
                         trans.set(2, 1, 0.0);
                         trans.set(2, 2, 1.0);
                         trans.set(2, 3, p.get(2));

                         trans.set(3, 0, 0.0);
                         trans.set(3, 1, 0.0);
                         trans.set(3, 2, 0.0);
                         trans.set(3, 3, 1.0);

                         ptStack[ptInd] = trans;
                 }
      } else {
        jj_expLA1[51] = jj_gen;
        if (jj_mask_50[getToken(1).kind]) {
          jj_consume_token(SCALE);
          p = ParsePoint();
                 Parameter dims = envi.getParamSet().get("dimensions");
                 int d = ((Integer)dims.getValue()).intValue();
                 if (d == 2) {
                         MatrixTrans trans = new MatrixTrans(3,3);

                         trans.set(0, 0, p.get(0));
                         trans.set(0, 1, 0.0);
                         trans.set(0, 2, 0.0);

                         trans.set(1, 0, 0.0);
                         trans.set(1, 1, p.get(1));
                         trans.set(1, 2, 0.0);

                         trans.set(2, 0, 0.0);
                         trans.set(2, 1, 0.0);
                         trans.set(2, 2, 1.0);

                         ptStack[ptInd] = trans;
                 } else if (d == 3) {
                         MatrixTrans trans = new MatrixTrans(4,4);

                         trans.set(0, 0, p.get(0));
                         trans.set(0, 1, 0.0);
                         trans.set(0, 2, 0.0);
                         trans.set(0, 3, 0.0);

                         trans.set(1, 0, 0.0);
                         trans.set(1, 1, p.get(1));
                         trans.set(1, 2, 0.0);
                         trans.set(1, 3, 0.0);

                         trans.set(2, 0, 0.0);
                         trans.set(2, 1, 0.0);
                         trans.set(2, 2, p.get(2));
                         trans.set(2, 3, 0.0);

                         trans.set(3, 0, 0.0);
                         trans.set(3, 1, 0.0);
                         trans.set(3, 2, 0.0);
                         trans.set(3, 3, 1.0);

                         ptStack[ptInd] = trans;
                 }
        } else {
          jj_expLA1[50] = jj_gen;
          if (jj_mask_49[getToken(1).kind]) {
            jj_consume_token(ROTATE);
            if (jj_mask_48[getToken(1).kind]) {
              p = ParsePoint();
            } else {
              jj_expLA1[48] = jj_gen;
              ;
            }
            jj_consume_token(BY);
            angle = ParseNumber();
                 Parameter dims = envi.getParamSet().get("dimensions");
                 int d = ((Integer)dims.getValue()).intValue();
                 if (d == 2) {
                         ptStack[ptInd] = TransUtil.rotation2d(angle.doubleValue());
                 } else if (d == 3) {
                         if (p == null) {
                                 envi.setErrorMsg("No rotation axis specified for 3D rotation");
                                 throw new ParseError();
                         }
                         ptStack[ptInd] = TransUtil.rotation3d(p, angle.doubleValue());
                 }
          } else {
            jj_expLA1[49] = jj_gen;
            jj_consume_token(-1);
            throw new ParseError();
          }
        }
      }
    }
  }

  static boolean[] jj_mask_48 = new boolean[91];
  static {
    jj_mask_48[LPAREN] =
    jj_mask_48[IDENTIFIER] = true;
  }
  static boolean[] jj_mask_49 = new boolean[91];
  static {
    jj_mask_49[ROTATE] = true;
  }
  static boolean[] jj_mask_50 = new boolean[91];
  static {
    jj_mask_50[SCALE] = true;
  }
  static boolean[] jj_mask_51 = new boolean[91];
  static {
    jj_mask_51[TRANSLATE] = true;
  }
  static boolean[] jj_mask_52 = new boolean[91];
  static {
    jj_mask_52[MAP] = true;
  }
  
  final public Number ParseNumber() throws ParseError {
         Number num, n1, n2;
    if (jj_2_13(2147483647)) {
      n1 = ParseProduct();
      jj_consume_token(PLUS);
      n2 = ParseNumber();
                         num = new Double(n1.doubleValue() + n2.doubleValue());
    } else {
      if (jj_2_12(2147483647)) {
        n1 = ParseProduct();
        jj_consume_token(MINUS);
        n2 = ParseNumber();
                         num = new Double(n1.doubleValue() - n2.doubleValue());
      } else {
        if (jj_mask_53[getToken(1).kind]) {
          num = ParseProduct();
        } else {
          jj_expLA1[53] = jj_gen;
          jj_consume_token(-1);
          throw new ParseError();
        }
      }
    }
                 return num;
  }

  static boolean[] jj_mask_53 = new boolean[91];
  static {
    jj_mask_53[INTEGER_LITERAL] =
    jj_mask_53[FLOATING_POINT_LITERAL] =
    jj_mask_53[LPAREN] =
    jj_mask_53[SIN] =
    jj_mask_53[COS] =
    jj_mask_53[TAN] =
    jj_mask_53[ASIN] =
    jj_mask_53[ACOS] =
    jj_mask_53[ATAN] =
    jj_mask_53[SQRT] =
    jj_mask_53[LOG] =
    jj_mask_53[EXP] =
    jj_mask_53[POWER] =
    jj_mask_53[MIN] =
    jj_mask_53[MAX] =
    jj_mask_53[RANDOM] =
    jj_mask_53[ABS] =
    jj_mask_53[EULER] =
    jj_mask_53[PI] =
    jj_mask_53[FLOOR] =
    jj_mask_53[CEIL] =
    jj_mask_53[RINT] =
    jj_mask_53[ATAN2] =
    jj_mask_53[RAD] =
    jj_mask_53[IDENTIFIER] = true;
  }
  
  final public Number ParseProduct() throws ParseError {
         Number num, n1, n2;
    if (jj_2_15(2147483647)) {
      n1 = ParseTerm();
      jj_consume_token(STAR);
      n2 = ParseProduct();
                         num = new Double(n1.doubleValue() * n2.doubleValue());
    } else {
      if (jj_2_14(2147483647)) {
        n1 = ParseTerm();
        jj_consume_token(SLASH);
        n2 = ParseProduct();
                         num = new Double(n1.doubleValue() / n2.doubleValue());
      } else {
        if (jj_mask_54[getToken(1).kind]) {
          num = ParseTerm();
        } else {
          jj_expLA1[54] = jj_gen;
          jj_consume_token(-1);
          throw new ParseError();
        }
      }
    }
                 return num;
  }

  static boolean[] jj_mask_54 = new boolean[91];
  static {
    jj_mask_54[INTEGER_LITERAL] =
    jj_mask_54[FLOATING_POINT_LITERAL] =
    jj_mask_54[LPAREN] =
    jj_mask_54[SIN] =
    jj_mask_54[COS] =
    jj_mask_54[TAN] =
    jj_mask_54[ASIN] =
    jj_mask_54[ACOS] =
    jj_mask_54[ATAN] =
    jj_mask_54[SQRT] =
    jj_mask_54[LOG] =
    jj_mask_54[EXP] =
    jj_mask_54[POWER] =
    jj_mask_54[MIN] =
    jj_mask_54[MAX] =
    jj_mask_54[RANDOM] =
    jj_mask_54[ABS] =
    jj_mask_54[EULER] =
    jj_mask_54[PI] =
    jj_mask_54[FLOOR] =
    jj_mask_54[CEIL] =
    jj_mask_54[RINT] =
    jj_mask_54[ATAN2] =
    jj_mask_54[RAD] =
    jj_mask_54[IDENTIFIER] = true;
  }
  
  final public Number ParseTerm() throws ParseError {
         Token s;
         Number num, n1, n2;
    if (jj_mask_82[getToken(1).kind]) {
      s = jj_consume_token(FLOATING_POINT_LITERAL);
                         try {
                                 num = Double.valueOf(s.image);
                         } catch (NumberFormatException e) {
                                 envi.setErrorMsg("'" + s.image + "' is not a valid floating point number.");
                                 throw new ParseError();
                         }
    } else {
      jj_expLA1[82] = jj_gen;
      if (jj_mask_81[getToken(1).kind]) {
        s = jj_consume_token(INTEGER_LITERAL);
                         try {
                                 num = Integer.valueOf(s.image);
                         } catch (NumberFormatException e) {
                                 envi.setErrorMsg("'" + s.image + "' is not a valid integer number.");
                                 throw new ParseError();
                         }
      } else {
        jj_expLA1[81] = jj_gen;
        if (jj_mask_80[getToken(1).kind]) {
          s = jj_consume_token(IDENTIFIER);
                         // Lookup in the parameters if the identifier is defined there
                         //
                         Parameter param = envi.getParamSet().get(s.image);
                         if (param == null) {
                                 envi.setErrorMsg("Undefined parameter '" + s.image + "' in expression.");
                                 throw new ParseError();
                         } else {
                                 Object value = param.getValue();
                                 if (! (value instanceof Number)) {
                                         envi.setErrorMsg("Parameter '" + s.image + "' is not of a numeric type.");
                                         throw new ParseError();
                                 } else {
                                         num = (Number)value;
                                 }
                         }
        } else {
          jj_expLA1[80] = jj_gen;
          if (jj_mask_79[getToken(1).kind]) {
            jj_consume_token(LPAREN);
            num = ParseNumber();
            jj_consume_token(RPAREN);
          } else {
            jj_expLA1[79] = jj_gen;
            if (jj_mask_78[getToken(1).kind]) {
              jj_consume_token(SIN);
              jj_consume_token(LPAREN);
              n1 = ParseNumber();
              jj_consume_token(RPAREN);
                         num = new Double(Math.sin(n1.doubleValue()));
            } else {
              jj_expLA1[78] = jj_gen;
              if (jj_mask_77[getToken(1).kind]) {
                jj_consume_token(COS);
                jj_consume_token(LPAREN);
                n1 = ParseNumber();
                jj_consume_token(RPAREN);
                         num = new Double(Math.cos(n1.doubleValue()));
              } else {
                jj_expLA1[77] = jj_gen;
                if (jj_mask_76[getToken(1).kind]) {
                  jj_consume_token(TAN);
                  jj_consume_token(LPAREN);
                  n1 = ParseNumber();
                  jj_consume_token(RPAREN);
                         num = new Double(Math.tan(n1.doubleValue()));
                } else {
                  jj_expLA1[76] = jj_gen;
                  if (jj_mask_75[getToken(1).kind]) {
                    jj_consume_token(ASIN);
                    jj_consume_token(LPAREN);
                    n1 = ParseNumber();
                    jj_consume_token(RPAREN);
                         num = new Double(Math.asin(n1.doubleValue()));
                  } else {
                    jj_expLA1[75] = jj_gen;
                    if (jj_mask_74[getToken(1).kind]) {
                      jj_consume_token(ACOS);
                      jj_consume_token(LPAREN);
                      n1 = ParseNumber();
                      jj_consume_token(RPAREN);
                         num = new Double(Math.acos(n1.doubleValue()));
                    } else {
                      jj_expLA1[74] = jj_gen;
                      if (jj_mask_73[getToken(1).kind]) {
                        jj_consume_token(ATAN);
                        jj_consume_token(LPAREN);
                        n1 = ParseNumber();
                        jj_consume_token(RPAREN);
                         num = new Double(Math.atan(n1.doubleValue()));
                      } else {
                        jj_expLA1[73] = jj_gen;
                        if (jj_mask_72[getToken(1).kind]) {
                          jj_consume_token(SQRT);
                          jj_consume_token(LPAREN);
                          n1 = ParseNumber();
                          jj_consume_token(RPAREN);
                         num = new Double(Math.sqrt(n1.doubleValue()));
                        } else {
                          jj_expLA1[72] = jj_gen;
                          if (jj_mask_71[getToken(1).kind]) {
                            jj_consume_token(LOG);
                            jj_consume_token(LPAREN);
                            n1 = ParseNumber();
                            jj_consume_token(RPAREN);
                         num = new Double(Math.log(n1.doubleValue()));
                          } else {
                            jj_expLA1[71] = jj_gen;
                            if (jj_mask_70[getToken(1).kind]) {
                              jj_consume_token(EXP);
                              jj_consume_token(LPAREN);
                              n1 = ParseNumber();
                              jj_consume_token(RPAREN);
                         num = new Double(Math.exp(n1.doubleValue()));
                            } else {
                              jj_expLA1[70] = jj_gen;
                              if (jj_mask_69[getToken(1).kind]) {
                                jj_consume_token(POWER);
                                jj_consume_token(LPAREN);
                                n1 = ParseNumber();
                                jj_consume_token(COMMA);
                                n2 = ParseNumber();
                                jj_consume_token(RPAREN);
                         num = new Double(Math.pow(n1.doubleValue(), n2.doubleValue()));
                              } else {
                                jj_expLA1[69] = jj_gen;
                                if (jj_mask_68[getToken(1).kind]) {
                                  jj_consume_token(MIN);
                                  jj_consume_token(LPAREN);
                                  n1 = ParseNumber();
                                  jj_consume_token(COMMA);
                                  n2 = ParseNumber();
                                  jj_consume_token(RPAREN);
                         num = new Double(Math.min(n1.doubleValue(), n2.doubleValue()));
                                } else {
                                  jj_expLA1[68] = jj_gen;
                                  if (jj_mask_67[getToken(1).kind]) {
                                    jj_consume_token(MAX);
                                    jj_consume_token(LPAREN);
                                    n1 = ParseNumber();
                                    jj_consume_token(COMMA);
                                    n2 = ParseNumber();
                                    jj_consume_token(RPAREN);
                         num = new Double(Math.max(n1.doubleValue(), n2.doubleValue()));
                                  } else {
                                    jj_expLA1[67] = jj_gen;
                                    if (jj_mask_66[getToken(1).kind]) {
                                      jj_consume_token(ATAN2);
                                      jj_consume_token(LPAREN);
                                      n1 = ParseNumber();
                                      jj_consume_token(COMMA);
                                      n2 = ParseNumber();
                                      jj_consume_token(RPAREN);
                         num = new Double(Math.atan2(n1.doubleValue(), n2.doubleValue()));
                                    } else {
                                      jj_expLA1[66] = jj_gen;
                                      if (jj_mask_65[getToken(1).kind]) {
                                        jj_consume_token(RANDOM);
                                        if (jj_mask_64[getToken(1).kind]) {
                                          jj_consume_token(LPAREN);
                                          jj_consume_token(RPAREN);
                                        } else {
                                          jj_expLA1[64] = jj_gen;
                                          ;
                                        }
                         num = new Double(Math.random());
                                      } else {
                                        jj_expLA1[65] = jj_gen;
                                        if (jj_mask_63[getToken(1).kind]) {
                                          jj_consume_token(EULER);
                                          if (jj_mask_62[getToken(1).kind]) {
                                            jj_consume_token(LPAREN);
                                            jj_consume_token(RPAREN);
                                          } else {
                                            jj_expLA1[62] = jj_gen;
                                            ;
                                          }
                         num = new Double(Math.E);
                                        } else {
                                          jj_expLA1[63] = jj_gen;
                                          if (jj_mask_61[getToken(1).kind]) {
                                            jj_consume_token(PI);
                                            if (jj_mask_60[getToken(1).kind]) {
                                              jj_consume_token(LPAREN);
                                              jj_consume_token(RPAREN);
                                            } else {
                                              jj_expLA1[60] = jj_gen;
                                              ;
                                            }
                         num = new Double(Math.PI);
                                          } else {
                                            jj_expLA1[61] = jj_gen;
                                            if (jj_mask_59[getToken(1).kind]) {
                                              jj_consume_token(ABS);
                                              jj_consume_token(LPAREN);
                                              n1 = ParseNumber();
                                              jj_consume_token(RPAREN);
                         num = new Double(Math.abs(n1.doubleValue()));
                                            } else {
                                              jj_expLA1[59] = jj_gen;
                                              if (jj_mask_58[getToken(1).kind]) {
                                                jj_consume_token(FLOOR);
                                                jj_consume_token(LPAREN);
                                                n1 = ParseNumber();
                                                jj_consume_token(RPAREN);
                         num = new Double(Math.floor(n1.doubleValue()));
                                              } else {
                                                jj_expLA1[58] = jj_gen;
                                                if (jj_mask_57[getToken(1).kind]) {
                                                  jj_consume_token(CEIL);
                                                  jj_consume_token(LPAREN);
                                                  n1 = ParseNumber();
                                                  jj_consume_token(RPAREN);
                         num = new Double(Math.ceil(n1.doubleValue()));
                                                } else {
                                                  jj_expLA1[57] = jj_gen;
                                                  if (jj_mask_56[getToken(1).kind]) {
                                                    jj_consume_token(RINT);
                                                    jj_consume_token(LPAREN);
                                                    n1 = ParseNumber();
                                                    jj_consume_token(RPAREN);
                         num = new Double(Math.rint(n1.doubleValue()));
                                                  } else {
                                                    jj_expLA1[56] = jj_gen;
                                                    if (jj_mask_55[getToken(1).kind]) {
                                                      jj_consume_token(RAD);
                                                      jj_consume_token(LPAREN);
                                                      n1 = ParseNumber();
                                                      jj_consume_token(RPAREN);
                         num = new Double(Math.PI / 180.0 * n1.doubleValue());
                                                    } else {
                                                      jj_expLA1[55] = jj_gen;
                                                      jj_consume_token(-1);
                                                      throw new ParseError();
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
                 return num;
  }

  static boolean[] jj_mask_55 = new boolean[91];
  static {
    jj_mask_55[RAD] = true;
  }
  static boolean[] jj_mask_56 = new boolean[91];
  static {
    jj_mask_56[RINT] = true;
  }
  static boolean[] jj_mask_57 = new boolean[91];
  static {
    jj_mask_57[CEIL] = true;
  }
  static boolean[] jj_mask_58 = new boolean[91];
  static {
    jj_mask_58[FLOOR] = true;
  }
  static boolean[] jj_mask_59 = new boolean[91];
  static {
    jj_mask_59[ABS] = true;
  }
  static boolean[] jj_mask_60 = new boolean[91];
  static {
    jj_mask_60[LPAREN] = true;
  }
  static boolean[] jj_mask_61 = new boolean[91];
  static {
    jj_mask_61[PI] = true;
  }
  static boolean[] jj_mask_62 = new boolean[91];
  static {
    jj_mask_62[LPAREN] = true;
  }
  static boolean[] jj_mask_63 = new boolean[91];
  static {
    jj_mask_63[EULER] = true;
  }
  static boolean[] jj_mask_64 = new boolean[91];
  static {
    jj_mask_64[LPAREN] = true;
  }
  static boolean[] jj_mask_65 = new boolean[91];
  static {
    jj_mask_65[RANDOM] = true;
  }
  static boolean[] jj_mask_66 = new boolean[91];
  static {
    jj_mask_66[ATAN2] = true;
  }
  static boolean[] jj_mask_67 = new boolean[91];
  static {
    jj_mask_67[MAX] = true;
  }
  static boolean[] jj_mask_68 = new boolean[91];
  static {
    jj_mask_68[MIN] = true;
  }
  static boolean[] jj_mask_69 = new boolean[91];
  static {
    jj_mask_69[POWER] = true;
  }
  static boolean[] jj_mask_70 = new boolean[91];
  static {
    jj_mask_70[EXP] = true;
  }
  static boolean[] jj_mask_71 = new boolean[91];
  static {
    jj_mask_71[LOG] = true;
  }
  static boolean[] jj_mask_72 = new boolean[91];
  static {
    jj_mask_72[SQRT] = true;
  }
  static boolean[] jj_mask_73 = new boolean[91];
  static {
    jj_mask_73[ATAN] = true;
  }
  static boolean[] jj_mask_74 = new boolean[91];
  static {
    jj_mask_74[ACOS] = true;
  }
  static boolean[] jj_mask_75 = new boolean[91];
  static {
    jj_mask_75[ASIN] = true;
  }
  static boolean[] jj_mask_76 = new boolean[91];
  static {
    jj_mask_76[TAN] = true;
  }
  static boolean[] jj_mask_77 = new boolean[91];
  static {
    jj_mask_77[COS] = true;
  }
  static boolean[] jj_mask_78 = new boolean[91];
  static {
    jj_mask_78[SIN] = true;
  }
  static boolean[] jj_mask_79 = new boolean[91];
  static {
    jj_mask_79[LPAREN] = true;
  }
  static boolean[] jj_mask_80 = new boolean[91];
  static {
    jj_mask_80[IDENTIFIER] = true;
  }
  static boolean[] jj_mask_81 = new boolean[91];
  static {
    jj_mask_81[INTEGER_LITERAL] = true;
  }
  static boolean[] jj_mask_82 = new boolean[91];
  static {
    jj_mask_82[FLOATING_POINT_LITERAL] = true;
  }
  
/**
 * Parses a label.
 * <p>
 * A label is considered to be a string enclosed in quotation marks, 
 * or a single alphabetic character, or an identifier. Returns the parsed 
 * entity as a <code>String</code>.
 */
  final public String ParseLabel() throws ParseError {
         String label;
    if (jj_mask_85[getToken(1).kind]) {
      label = ParseString();
    } else {
      jj_expLA1[85] = jj_gen;
      if (jj_mask_84[getToken(1).kind]) {
        label = ParseCharacter();
      } else {
        jj_expLA1[84] = jj_gen;
        if (jj_mask_83[getToken(1).kind]) {
          label = ParseIdentifier();
        } else {
          jj_expLA1[83] = jj_gen;
          jj_consume_token(-1);
          throw new ParseError();
        }
      }
    }
                 return label;
  }

  static boolean[] jj_mask_83 = new boolean[91];
  static {
    jj_mask_83[IDENTIFIER] = true;
  }
  static boolean[] jj_mask_84 = new boolean[91];
  static {
    jj_mask_84[CHARACTER_LITERAL] = true;
  }
  static boolean[] jj_mask_85 = new boolean[91];
  static {
    jj_mask_85[STRING_LITERAL] = true;
  }
  
/**
 * Parses a string enclosed in quotation marks.
 * <p>
 * The quotation marks are excluded from the resulting string.
 */
  final public String ParseString() throws ParseError {
         Token string;
    string = jj_consume_token(STRING_LITERAL);
                 return string.image.substring(1, string.image.length()-1);
  }

/**
 * Parses a single character and returns it as a string.
 */
  final public String ParseCharacter() throws ParseError {
         Token character;
    character = jj_consume_token(CHARACTER_LITERAL);
                 if (character.image.length() == 1) {
                         return character.image;
                 } else {
                         return character.image.substring(1, character.image.length()-1);
                 }
  }

/**
 * Parses a boolean constant, which may be either "true" or "false".
 */
  final public Boolean ParseBoolean() throws ParseError {
    if (jj_mask_87[getToken(1).kind]) {
      jj_consume_token(BOOL_TRUE);
                 return new Boolean(true);
    } else {
      jj_expLA1[87] = jj_gen;
      if (jj_mask_86[getToken(1).kind]) {
        jj_consume_token(BOOL_FALSE);
                 return new Boolean(false);
      } else {
        jj_expLA1[86] = jj_gen;
        jj_consume_token(-1);
        throw new ParseError();
      }
    }
  }

  static boolean[] jj_mask_86 = new boolean[91];
  static {
    jj_mask_86[BOOL_FALSE] = true;
  }
  static boolean[] jj_mask_87 = new boolean[91];
  static {
    jj_mask_87[BOOL_TRUE] = true;
  }
  
/**
 * Parses an identifier and returns it as a string.
 */
  final public String ParseIdentifier() throws ParseError {
         Token ident;
    ident = jj_consume_token(IDENTIFIER);
                 return ident.image;
  }

  final private boolean jj_2_1(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_2_5(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  final private boolean jj_2_6(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_6();
    jj_save(5, xla);
    return retval;
  }

  final private boolean jj_2_7(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_7();
    jj_save(6, xla);
    return retval;
  }

  final private boolean jj_2_8(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_8();
    jj_save(7, xla);
    return retval;
  }

  final private boolean jj_2_9(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_9();
    jj_save(8, xla);
    return retval;
  }

  final private boolean jj_2_10(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_10();
    jj_save(9, xla);
    return retval;
  }

  final private boolean jj_2_11(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_11();
    jj_save(10, xla);
    return retval;
  }

  final private boolean jj_2_12(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_12();
    jj_save(11, xla);
    return retval;
  }

  final private boolean jj_2_13(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_13();
    jj_save(12, xla);
    return retval;
  }

  final private boolean jj_2_14(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_14();
    jj_save(13, xla);
    return retval;
  }

  final private boolean jj_2_15(int xla) throws ParseError {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_15();
    jj_save(14, xla);
    return retval;
  }

  final private boolean jj_3_1() throws ParseError {
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() throws ParseError {
    if (jj_3R_9()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() throws ParseError {
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_11()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() throws ParseError {
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_5() throws ParseError {
    if (jj_3R_9()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_6() throws ParseError {
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_9()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_7() throws ParseError {
    if (jj_3R_12()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    if (jj_3R_13()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_13()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_8() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SLASH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_9() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_10() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_11() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_12() throws ParseError {
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_13() throws ParseError {
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_14() throws ParseError {
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SLASH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_15() throws ParseError {
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_8() throws ParseError {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_9() throws ParseError {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_23()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_10() throws ParseError {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_11() throws ParseError {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_12() throws ParseError {
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_13() throws ParseError {
    if (jj_3R_12()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_14() throws ParseError {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_15() throws ParseError {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_16() throws ParseError {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_17() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_18() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_19() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_20() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_21() throws ParseError {
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_22() throws ParseError {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_23() throws ParseError {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_24() throws ParseError {
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_25() throws ParseError {
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_26() throws ParseError {
    if (jj_3R_11()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_27() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_28() throws ParseError {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_29() throws ParseError {
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_30() throws ParseError {
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SLASH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_31() throws ParseError {
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_32() throws ParseError {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_33() throws ParseError {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_34() throws ParseError {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_35() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_36() throws ParseError {
    if (jj_scan_token(SIN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_37() throws ParseError {
    if (jj_scan_token(COS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() throws ParseError {
    if (jj_scan_token(TAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() throws ParseError {
    if (jj_scan_token(ASIN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() throws ParseError {
    if (jj_scan_token(ACOS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_41() throws ParseError {
    if (jj_scan_token(ATAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() throws ParseError {
    if (jj_scan_token(SQRT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_43() throws ParseError {
    if (jj_scan_token(LOG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_44() throws ParseError {
    if (jj_scan_token(EXP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() throws ParseError {
    if (jj_scan_token(POWER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() throws ParseError {
    if (jj_scan_token(MIN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() throws ParseError {
    if (jj_scan_token(MAX)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() throws ParseError {
    if (jj_scan_token(ATAN2)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() throws ParseError {
    if (jj_scan_token(RANDOM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_50() throws ParseError {
    if (jj_scan_token(EULER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() throws ParseError {
    if (jj_scan_token(PI)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_52() throws ParseError {
    if (jj_scan_token(ABS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() throws ParseError {
    if (jj_scan_token(FLOOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() throws ParseError {
    if (jj_scan_token(CEIL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_55() throws ParseError {
    if (jj_scan_token(RINT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() throws ParseError {
    if (jj_scan_token(RAD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() throws ParseError {
    if (jj_3R_12()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    if (jj_3R_71()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_71()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_58() throws ParseError {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_59() throws ParseError {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_60() throws ParseError {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_61() throws ParseError {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_62() throws ParseError {
    if (jj_scan_token(SLASH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_63() throws ParseError {
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_64() throws ParseError {
    if (jj_scan_token(CHARACTER_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_65() throws ParseError {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_66() throws ParseError {
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_67() throws ParseError {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_68() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_69() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_70() throws ParseError {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_71() throws ParseError {
    if (jj_3R_12()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_72() throws ParseError {
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_73() throws ParseError {
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_74() throws ParseError {
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public CSParserTokenManager token_source;
  public Token token;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private CSParser jj_me;
  private int jj_gen;
  private int[] jj_expLA1 = new int[88];
  private JJCSParserCalls[] jj_2_rtns = new JJCSParserCalls[15];
  private boolean jj_rescan = false;

  public CSParser(java.io.InputStream stream) {
    ASCII_UCodeESC_CharStream input_stream = new ASCII_UCodeESC_CharStream(stream, 1, 1);
    token_source = new CSParserTokenManager(input_stream);
    token = new Token();
    jj_me = this;
    jj_gen = 0;
    for (int i = 0; i < 88; i++) jj_expLA1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCSParserCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    ASCII_UCodeESC_CharStream input_stream = new ASCII_UCodeESC_CharStream(stream, 1, 1);
    token_source.ReInit(input_stream);
    token = new Token();
    jj_gen = 0;
    for (int i = 0; i < 88; i++) jj_expLA1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCSParserCalls();
  }

  public CSParser(CSParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_me = this;
    jj_gen = 0;
    for (int i = 0; i < 88; i++) jj_expLA1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCSParserCalls();
  }

  public void ReInit(CSParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_gen = 0;
    for (int i = 0; i < 88; i++) jj_expLA1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCSParserCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseError {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    jj_token_error_setup(token, kind);
    throw new ParseError();
  }

  final private boolean jj_scan_token(int kind) throws ParseError {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 1; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() throws ParseError {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) throws ParseError {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  static final String jj_add_escapes(String str) {
    String retval = "";
    char ch;
    for (int i = 0; i < str.length(); i++) {
      ch = str.charAt(i);
      if (ch == '\b') {
        retval += "\\b";
      } else if (ch == '\t') {
        retval += "\\t";
      } else if (ch == '\n') {
        retval += "\\n";
      } else if (ch == '\f') {
        retval += "\\f";
      } else if (ch == '\r') {
        retval += "\\r";
      } else if (ch == '\"') {
        retval += "\\\"";
      } else if (ch == '\'') {
        retval += "\\\'";
      } else if (ch == '\\') {
        retval += "\\\\";
      } else if (ch < 0x20 || ch > 0x7e) {
        String s = "0000" + Integer.toString(ch, 16);
        retval += "\\u" + s.substring(s.length() - 4, s.length());
      } else {
        retval += ch;
      }
    }
    return retval;
  }

  protected int error_line;
  protected int error_column;
  protected String error_string;
  protected String[] expected_tokens;

  protected void token_error() {
    System.out.println("");
    System.out.println("Parse error at line " + error_line + ", column " + error_column + ".  Encountered:");
    System.out.println("    \"" + jj_add_escapes(error_string) + "\"");
    System.out.println("");
    if (expected_tokens.length == 1) {
      System.out.println("Was expecting:");
    } else {
      System.out.println("Was expecting one of:");
    }
    for (int i = 0; i < expected_tokens.length; i++) {
      System.out.println("    " + expected_tokens[i]);
    }
    System.out.println("");
  }

  private java.util.Vector jj_errortokens = new java.util.Vector();
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos, jj_maxsize;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      if (jj_endpos > jj_maxsize) jj_maxsize = jj_endpos;
      String buf = "";
      for (int i = 0; i < jj_endpos; i++) {
        buf += tokenImage[jj_lasttokens[i]] + " ";
      }
      if (jj_lasttokens[jj_endpos-1] != 0) buf += "...";
      boolean exists = false;
      for (java.util.Enumeration enum = jj_errortokens.elements(); enum.hasMoreElements();) {
        if (buf.equals((String)(enum.nextElement()))) {
          exists = true;
        }
      }
      if (!exists) jj_errortokens.addElement(buf);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final private void jj_token_error_setup(Token current, int kind) throws ParseError {
    jj_errortokens.removeAllElements();
    boolean[] la1tokens = new boolean[91];
    boolean[] mask = null;
    for (int i = 0; i < 91; i++) {
      la1tokens[i] = false;
    }
    if (kind >= 0) la1tokens[kind] = true;
    for (int i = 0; i < 88; i++) {
      if (jj_expLA1[i] == jj_gen) {
        switch (i) {
          case 0: mask = jj_mask_0; break;
          case 1: mask = jj_mask_1; break;
          case 2: mask = jj_mask_2; break;
          case 3: mask = jj_mask_3; break;
          case 4: mask = jj_mask_4; break;
          case 5: mask = jj_mask_5; break;
          case 6: mask = jj_mask_6; break;
          case 7: mask = jj_mask_7; break;
          case 8: mask = jj_mask_8; break;
          case 9: mask = jj_mask_9; break;
          case 10: mask = jj_mask_10; break;
          case 11: mask = jj_mask_11; break;
          case 12: mask = jj_mask_12; break;
          case 13: mask = jj_mask_13; break;
          case 14: mask = jj_mask_14; break;
          case 15: mask = jj_mask_15; break;
          case 16: mask = jj_mask_16; break;
          case 17: mask = jj_mask_17; break;
          case 18: mask = jj_mask_18; break;
          case 19: mask = jj_mask_19; break;
          case 20: mask = jj_mask_20; break;
          case 21: mask = jj_mask_21; break;
          case 22: mask = jj_mask_22; break;
          case 23: mask = jj_mask_23; break;
          case 24: mask = jj_mask_24; break;
          case 25: mask = jj_mask_25; break;
          case 26: mask = jj_mask_26; break;
          case 27: mask = jj_mask_27; break;
          case 28: mask = jj_mask_28; break;
          case 29: mask = jj_mask_29; break;
          case 30: mask = jj_mask_30; break;
          case 31: mask = jj_mask_31; break;
          case 32: mask = jj_mask_32; break;
          case 33: mask = jj_mask_33; break;
          case 34: mask = jj_mask_34; break;
          case 35: mask = jj_mask_35; break;
          case 36: mask = jj_mask_36; break;
          case 37: mask = jj_mask_37; break;
          case 38: mask = jj_mask_38; break;
          case 39: mask = jj_mask_39; break;
          case 40: mask = jj_mask_40; break;
          case 41: mask = jj_mask_41; break;
          case 42: mask = jj_mask_42; break;
          case 43: mask = jj_mask_43; break;
          case 44: mask = jj_mask_44; break;
          case 45: mask = jj_mask_45; break;
          case 46: mask = jj_mask_46; break;
          case 47: mask = jj_mask_47; break;
          case 48: mask = jj_mask_48; break;
          case 49: mask = jj_mask_49; break;
          case 50: mask = jj_mask_50; break;
          case 51: mask = jj_mask_51; break;
          case 52: mask = jj_mask_52; break;
          case 53: mask = jj_mask_53; break;
          case 54: mask = jj_mask_54; break;
          case 55: mask = jj_mask_55; break;
          case 56: mask = jj_mask_56; break;
          case 57: mask = jj_mask_57; break;
          case 58: mask = jj_mask_58; break;
          case 59: mask = jj_mask_59; break;
          case 60: mask = jj_mask_60; break;
          case 61: mask = jj_mask_61; break;
          case 62: mask = jj_mask_62; break;
          case 63: mask = jj_mask_63; break;
          case 64: mask = jj_mask_64; break;
          case 65: mask = jj_mask_65; break;
          case 66: mask = jj_mask_66; break;
          case 67: mask = jj_mask_67; break;
          case 68: mask = jj_mask_68; break;
          case 69: mask = jj_mask_69; break;
          case 70: mask = jj_mask_70; break;
          case 71: mask = jj_mask_71; break;
          case 72: mask = jj_mask_72; break;
          case 73: mask = jj_mask_73; break;
          case 74: mask = jj_mask_74; break;
          case 75: mask = jj_mask_75; break;
          case 76: mask = jj_mask_76; break;
          case 77: mask = jj_mask_77; break;
          case 78: mask = jj_mask_78; break;
          case 79: mask = jj_mask_79; break;
          case 80: mask = jj_mask_80; break;
          case 81: mask = jj_mask_81; break;
          case 82: mask = jj_mask_82; break;
          case 83: mask = jj_mask_83; break;
          case 84: mask = jj_mask_84; break;
          case 85: mask = jj_mask_85; break;
          case 86: mask = jj_mask_86; break;
          case 87: mask = jj_mask_87; break;
        }
        for (int j = 0; j < 91; j++) {
          if (mask[j]) la1tokens[j] = true;
        }
      }
    }
    if (la1tokens[0]) {
      jj_errortokens.addElement(tokenImage[0] + " ");
    }
    for (int i = 1; i < 91; i++) {
      if (la1tokens[i]) {
        jj_errortokens.addElement(tokenImage[i] + " ...");
      }
    }
    jj_endpos = 0;
    jj_maxsize = 1;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    expected_tokens = new String[jj_errortokens.size()];
    for (int i = 0; i < jj_errortokens.size(); i++) {
      expected_tokens[i] = (String)(jj_errortokens.elementAt(i));
    }
    error_line = current.beginLine;
    error_column = current.beginColumn;
    error_string = "";
    Token tok = current;
    for (int i = 0; i < jj_maxsize; i++) {
      if (tok.kind == 0) {
        error_string += " " + tokenImage[0];
        break;
      }
      error_string += " " + tok.image;
      tok = tok.next;
    }
    error_string = error_string.substring(1);
    jj_me.token_error();
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  private void jj_rescan_token() throws ParseError {
    jj_rescan = true;
    for (int i = 0; i < 15; i++) {
      JJCSParserCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCSParserCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCSParserCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

}

class JJCSParserCalls {
  int gen;
  Token first;
  int arg;
  JJCSParserCalls next;
}
