/*
 * @(#)Polygon.java
 * 
 */

package collage.parts;

import openstar.generic.*;
import openstar.util.*;
import collage.generic.*;
import collage.kernel.*;
import collage.vrml.*;
import collage.ui.*;

/**
 * Polygon part class.
 *
 * @version 23 Jun 1997
 * @author 	Nils Schwabe
 */  
public class Polygon extends Edge implements IVRMLPart, IAWTPart 
{

/** The point sequence of the polygon. */
protected PointSequence ps;


/** The RGB color of the part. */
protected Point color;


public Polygon(PointSequence ps) {
	this.ps = ps;
	color = new Point(150, 150, 150);
}

protected Polygon() {
}


public void setColor(Point rgbColor) {
	color = rgbColor;
}


public void transform(Transformation t) {
	ps.transform(t);
}


public Transformation findTrans(PointSequence s,
                                TransFinder finder,
                                boolean inverse) {
	if (inverse) {
		return finder.findTrans(ps, s);
	} else {
		return finder.findTrans(s, ps);
	}                                
}
                                                       

public boolean equals(Object object) {
	if (! (object instanceof Polygon)) {
		return false;
	}
	return ps.cyclicIdentical(((Polygon)object).ps);
}


public Object clone() {
	Polygon poly = new Polygon();
	poly.ps = (PointSequence)ps.clone();
	poly.color = (Point)color.clone();
	poly.label = label;
	poly.eqClass = eqClass;
	return poly;
}


public void vrmlOutput(java.io.PrintWriter writer) {
	
	writer.println("\nSeparator {");	
	
	//
	// Color
	//
	writer.println("  Material {");
	writer.println("    diffuseColor " 
	               + color.get(0) / 255.0 + " "
	               + color.get(1) / 255.0 + " "
	               + color.get(2) / 255.0);
	writer.println("    ambientColor .5 .5 .5");
	writer.println("  }");
	
	//
	// Polygon
	//	
	writer.print("  Coordinate3 {point[");
	Point p = (Point)ps.getAt(0);
	int i = 0;
	while (p != null) {
		writer.print(p.get(0)+" "+p.get(1)+" "+p.get(2));
		p = (Point)ps.getAt(++i);
		if (p != null) {
			writer.print(",");
		}
	}
 	p = (Point)ps.getAt(0); // repeat last point
	if (p != null) {
		writer.print(","+p.get(0)+" "+p.get(1)+" "+p.get(2));
	}
	writer.println("]}");
	
	writer.print("  IndexedFaceSet {coordIndex [");
	p = (Point)ps.getAt(0);
	i = 0;
	while (p != null) {
		writer.print(i+" ");
		p = (Point)ps.getAt(++i);
		if (p != null) {
			writer.print(",");
		}
	}
	writer.println("]}");
	writer.println("\n} #Separator");
}	


public void awtOutput(AWTDisplayContext context) {
	java.awt.Graphics graphics = context.getGraphics();
	int numPoints = ps.size();
	int x[] = new int[numPoints], y[] = new int[numPoints];
	for (int i=0; i < numPoints; i++) {
		x[i] = context.xOut((int)((Point)ps.getAt(i)).get(0));
		y[i] = context.yOut((int)((Point)ps.getAt(i)).get(1));
	}
	graphics.setColor(new java.awt.Color((int)color.get(0), (int)color.get(1), (int)color.get(2)));	
	graphics.fillPolygon(x, y, numPoints);
}


} // class Polygon

