/*
 * @(#)PolygonFactory.java
 * 
 */

package collage.parts;

import openstar.generic.*;
import openstar.util.*;
import collage.generic.*;

/**
 * Polygon part factory class.
 * <p>
 * This factory creates <code>Polygon</code> objects.
 * 
 * @version 23 Jun 1997
 * @author 	Nils Schwabe
 */ 
public class PolygonFactory extends PartFactory
{

protected final static String POINTS = "points";
protected final static String COLOR = "color";

public int newParam(String name, Object value) {

	if (   (name.equals(COLOR) && ! (value instanceof Point))
	    || (name.equals(POINTS) && ! (value instanceof PointSequence))) {
		return Factory.ERR_WRONG_TYPE;
	}
	return super.newParam(name, value);
}


public String[] missingParams() {

	if (get(POINTS) == null) {
		String[] missing = new String[1];
		missing[0] = POINTS;
		return missing;
	}
	return super.missingParams();
}

public Object create() {

	Parameter points = get(POINTS);
	Polygon poly = new Polygon((PointSequence)points.getValue());
	Parameter color = get(COLOR);
	if (color != null) {
		poly.setColor((Point)color.getValue());
	}
	return poly;
}


} // class PolygonFactory

