
package collage.server.ServerVR;

import java.io.*;
import java.util.*;
import java.servlet.*;
import java.servlet.http.*;


public class ServerVR extends HttpServlet {


static {
	System.out.println("CollageServer loaded.");
}

public void service(HttpServletRequest req, HttpServletResponse res)
			throws IOException {
			
			
	String csaction = req.getParameter("csaction");
	String vrmlfilename = req.getParameter("vrmlfilename");
	String cgrfilename = req.getParameter("cgrfilename");
	String cstext = req.getParameter("cstext");
	
/*	
	System.out.println("CollageServer: incoming request...");
	System.out.println("  csaction = " + csaction);
	System.out.println("  vrmlfilename = " + vrmlfilename);
	System.out.println("  cgrfilename = " + cgrfilename);
	if (cstext != null)
		System.out.println("  cstext is available");
*/
	
	
	PrintWriter out = new PrintWriter(res.getOutputStream());
	
	if (vrmlfilename != null) {
		//
		// Direct request for a particular VRML file on the server
		//
		serviceVRML(res, out, vrmlfilename);
		out.close();
		return;
	} 
	
	if (cgrfilename != null) {
		//
		// Request to proecess a grammar file (execute or edit)
		//
		serviceCGR(res, out, cgrfilename, csaction);
		out.close();
		return;
	}
	
	if (cstext != null) {
		//
		// Request to execute user-edited text as a collage grammar
		//
		serviceUserText(res, out, cstext);
		out.close();
		return;	
	}

	//
	// Return the start page of the CollageServer
	//	
	serviceStart(res, out);
	out.close();
}


public String getServletInfo() {
	return "CollageSystem VR server version 0.1";
}


private void serviceStart(HttpServletResponse res, PrintWriter out) {


	doStartPage(res, out, "");	
}
	
	


private void serviceVRML(HttpServletResponse res, PrintWriter out, String vrmlfilename) {

	String[] fileContent = new String[1];
	if (! readFileIntoString(res, out, fileContent, vrmlfilename))
		return; // error message has alredy been generated		 
	res.setContentType("x-world/x-vrml");
 	out.print(fileContent[0]);
}


private void serviceCGR(HttpServletResponse res, PrintWriter out, 
                        String cgrfilename, String action) {

	//
	// Check action
	//
	if (action == null) {
		serviceError(res, out, "There was no 'csaction' variable specified in the request to process the grammar file '" + cgrfilename + "'.");
		return;
	} else if (! (action.equals("csexec") || action.equals("csedit"))) {
		serviceError(res, out, "There was an illegal 'csaction' variable (the passed value was '" + action + "') specified in the request to process the grammar file '" + cgrfilename + "'.");
		return;
	}
		

	//
	// Check if file is there and readable.
	//
	cgrfilename = "/home/ns/CollageVR/cgr/" + cgrfilename + ".cgr";
	File file = new File(cgrfilename);
	if (! file.exists()) {
		serviceError(res, out, "The grammar file '"+cgrfilename+"' does not exist on the server.");
		return;
	}
	if (! file.canRead()) {
		serviceError(res, out, "The CollageServer does not have the permission to read the file '"+cgrfilename+"'.");
		return;
	}

	if (action.equals("csexec")) {
		doCgrExec(res, out, cgrfilename);
	} else if (action.equals("csedit")) {
		doCgrLoad(res, out, cgrfilename);
	}
}


private void serviceUserText(HttpServletResponse res, PrintWriter out, 
                             String userText) {
             
	//
	// Remove return characters from the HTML-encoded 'userText'
	// and make a raw security check concerning the use of the
	// 'eval' option.
	//
	if (userText.indexOf("/eval") >= 0) {
		serviceError(res, out, "Sorry, but the use of the '/eval' option is currently not allowed in files submitted by users due to security concerns.");
		return;
	}
	int len = userText.length();
	char[] userBuf = new char[len]; 
	char c;
	int j=0;
	for (int i=0; i < len; i++) {
		c = userText.charAt(i);
		if (c != 13)
			userBuf[j++] = c;
	}
	userText = new String(userBuf, 0, j);
                      
	//
	// Create and execute user grammar file
	//                      
	String userGrammar = "/home/ns/CollageVR/cgr/userGrammar.cgr";
	if (userText.length() <= 20) {
		serviceError(res, out, "The submitted text is too short to be a valid grammar file.");
		return;
	}
	File file = new File(userGrammar);
	FileOutputStream ostream;
	try {
		ostream = new FileOutputStream(file);
		byte[] buffer = userText.getBytes();
		ostream.write(buffer);
		ostream.close();
		doCgrExec(res, out, userGrammar);
    } catch (Exception e) {
		serviceError(res, out, "An exception occured while creating an internal file:<BR>"+e.toString());
		return;
	}	                             
}
                             

private void doStartPage(HttpServletResponse res, PrintWriter out,
                         String editorText) {	
	
	res.setContentType("text/html");
	out.println("<HTML><HEAD><TITLE>The CollageServer (alpha)</TITLE></HEAD>");
	out.println("<BODY BGCOLOR=\"#eeeeff\" TEXT=\"#000000\" LINK=\"#990000\" ALINK=\"#333399\" VLINK=\"#333399\">");
	out.println("<H1>The CollageServer (alpha)</H1>");
	out.println("<P>Welcome to the alpha version of the CollageServer. Note that this version is not yet intended for public use.<BR>");
	out.println("<P>We have provided some example collage grammars which you can use as a starting point for your own experiments.<BR>");
	out.println("<FORM Method=POST Action=\"http://golem.informatik.uni-bremen.de:8080/csserver\">");
	out.println("<SELECT Name=\"cgrfilename\">");
	out.println("<OPTION Value=SierpTetra3D>Sierpinski Tetraeder");
	out.println("<OPTION Value=Cover3D3>Cover image from progress report '96");
	out.println("<OPTION Value=L3D2>The 'L', version 1");
	out.println("<OPTION Value=L3D3>The 'L', version 2");
	out.println("<OPTION Value=L3D4>The 'L', version 3");
	out.println("<OPTION Value=L3D5>The 'L', version 4");
	out.println("<OPTION Value=Tree3D3>A tree");
	out.println("<OPTION Value=Weihbaum3D3>A christmas tree");	
	out.println("</SELECT><BR>");
	out.println("<INPUT Type=Radio Name=csaction Value=csexec CHECKED><B> Execute the selected grammar</B><BR>");
	out.println("<INPUT Type=Radio Name=csaction Value=csedit><B> Load the grammar file into the editor below</B><BR>");
	out.println("<INPUT Type=Submit Value=\"Do it!\">");
	out.println("</FORM><FORM Method=POST Action=\"http://golem.informatik.uni-bremen.de:8080/csserver\">");
	out.println("<TEXTAREA Name=\"cstext\" Cols=70 Rows=18>");
	out.println(editorText);
	out.println("</TEXTAREA>");
	out.println("<INPUT Type=Submit Value=\"Execute the edited grammar\">");
	out.println("</BODY></HTML>");
}


private void doCgrLoad(HttpServletResponse res, PrintWriter out, 
                       String cgrfilename)
{
	String[] resultList = new String[1];
	if (! readFileIntoString(res, out, resultList, cgrfilename))
		return; // error message has already been generated
	doStartPage(res, out, resultList[0]);
}


private void doCgrExec(HttpServletResponse res, PrintWriter out, 
                       String cgrfilename)
{
	//
	// Invoke CollageVR in silent mode
	//
	try {
		Process p = Runtime.getRuntime().exec ("/home/ns/CollageVR/cs "+cgrfilename+" -silent");
		if (p == null) {
			serviceError(res, out, "CollageVR process could not be started.");
			return;
		}
		p.waitFor();		
    } catch (IOException e) {
    	serviceError(res, out, "An I/O exception occured while starting CollageVR:<br>" + e.toString()); 
    	return;
	} catch (InterruptedException e) {
		serviceError(res, out, "Interrupt exception occured while executing CollageVR:<BR>" + e.toString()); 
		return;
	}
	
	String[] resultList = new String[1];
	if (! readFileIntoString(res, out, resultList, "csresult.txt"))
		return; // error message has already been generated
	String[] errorMsg = new String[1];
	if (! readFileIntoString(res, out, errorMsg, "cserr.txt"))
		return; // error message has already been generated
			
	res.setContentType("text/html");
	out.println("<HTML><HEAD><TITLE>CollageServer results</TITLE></HEAD>");
	out.println("<BODY><H1>CollageServer results</H1>");
	if (errorMsg[0].length() <= 1) {
		out.println("<P>Your request to the CollageServer was processed. The generated VRML files are:<br><br>");
	
		StringTokenizer tokenizer = new StringTokenizer(resultList[0], "\n");
		String aToken;
		while (tokenizer.hasMoreTokens()) {
			aToken = tokenizer.nextToken();
			out.println("<A href=http://golem.informatik.uni-bremen.de:8080/csserver?vrmlfilename="
			            + aToken + ">" + aToken + "</A><BR>");
		}
	} else {
		out.println("<P>The collage grammar could not be processed because of the following error:<br><br>");
		out.println("<B>" + errorMsg[0] + "</B>");
	}
	
	out.println("</BODY></HTML>");	
}


private void serviceError(HttpServletResponse res, PrintWriter out, String message) {

	res.setContentType("text/html");
	out.println("<HTML><HEAD><TITLE>CollageServer request error</TITLE></HEAD>");
	out.println("<BODY><H1>CollageServer request error</H1>");
	out.println("<P>Your request could not be processed by the CollageServer, because the following error occured:");
	out.println("<H2>" + message + "</H2>");
	out.println("</BODY></HTML>");
}


private boolean readFileIntoString(HttpServletResponse res, PrintWriter out, 
                                   String[] resultString, String filename) {

	//
	// Check if file is there and readable.
	//
	File file = new File(filename);
	if (! file.exists()) {
		serviceError(res, out, "The file '"+filename+"' does not exist on the server.");
		return false;
	}
	if (! file.canRead()) {
		serviceError(res, out, "The CollageServer does not have the permission to read the file '"+filename+"'.");
		return false;
	}
	
	//
	// Open and read input stream.
	//
	FileInputStream istream;
	try {
		istream = new FileInputStream(file);
    } catch (FileNotFoundException e) {
		serviceError(res, out, "The file '"+filename+"' could not be opened.");
		return false;
	} catch (IOException e) {
		serviceError(res, out, "An I/O exception occured while opening the file '"+filename+"':<br>"+e.toString());
		return false;
	}
	
	int length = 0;
	try {
		length = istream.available();
    	if (length <= 0) {
			istream.close();
			resultString[0] = new String("");
			return true;
		}
		byte[] buffer = new byte[length];
		istream.read (buffer, 0, length);
		resultString[0] = new String(buffer);
		istream.close();			
	} catch (IOException e) {
		try {istream.close();} catch (IOException dummy) {}
		serviceError(res, out, "An I/O exception occured while reading the file '"+filename+"':<br>"+e.toString());
		return false;
	}	
	return true;
}


} // class ServerVR
