/*
 * @(#)AWTDisplay.java
 * 
 */

package collage.ui;

import java.awt.*;

import openstar.util.Point;
import openstar.util.PointSequence;
import collage.kernel.*;
import collage.generic.*;


/**
 * CollageSystem AWT display class.
 *
 * @version 09 Jun 1997
 * @author 	Nils Schwabe
 */ 
public class AWTDisplay implements AWTDisplayContext
{

protected Graphics graphics;
protected Dimension size;
protected java.awt.Point offset;
protected double xzoom;
protected double yzoom;

public AWTDisplay(Graphics graphics, Dimension size) {

	this.graphics = graphics;
	this.size = size;
	offset = new java.awt.Point(0,0);
	xzoom = 1.0;
	yzoom = 1.0;
}


public void setOffset(java.awt.Point offset) {
	this.offset = offset;
}


public java.awt.Point getOffset() {
	return offset;
}


public void setZoomX(double xz) {
	xzoom = xz;
}


public double getZoomX() {
	return xzoom;
}


public void setZoomY(double yz) {
	yzoom = yz;
}


public double getZoomY() {
	return yzoom;
}


public void zoomRect(int x, int y, int w, int h) {

	if (w == 0 || h == 0) {
		return;
	}
	if (w < 0) {
		x += w; 
		w = -w;
	}
	if (h < 0) {
		y += h; 
		h = -h;
	}
	y = size.height - y - h;
	double xN = (x - offset.x) / xzoom; 
	double yN = (y - offset.y) / yzoom;
	double fw = (double)size.width / (double)w; // >= 1
	double fh = (double)size.height /(double)h; // >= 1
	xzoom *= fw;
	yzoom *= fh;
	offset.x = (int)(-xN*xzoom);
	offset.y = (int)(-yN*yzoom);
}


public void zoomIn() {

	zoomRect((int)(0.1*size.width), (int)(0.1*size.height), 
	         (int)(0.8*size.width), (int)(0.8*size.height));

}


public void zoomOut() {

	zoomRect((int)(-0.125*size.width), (int)(-0.125*size.height), 
	         (int)(1.25*size.width), (int)(1.25*size.height));
}


public void resetView() {

	xzoom = 1.0;
	yzoom = 1.0;
	offset.x = 0;
	offset.y = 0;
}



public void displayCollage(Envi envi,
                           Collage collage)  {	
                                                      
	EdgeSet edges = collage.getEdges();
	Edge e = (Edge)edges.getAt(0);
	int i = 0;
	while (e != null) {
		if (e instanceof IAWTPart) {
			((IAWTPart)e).awtOutput(this);
		} else {
			displayEdge(e, collage, envi);
		}
		e = (Edge)edges.getAt(++i);
	}	                                                 
}


public int xOut(double x) {
	return (int)(x * xzoom + offset.x);
}


public int yOut(double y) {
	return size.height - (int)(y * yzoom + offset.y);
}


public Graphics getGraphics() {
	return graphics;
}

protected void displayEdge(Edge edge,
                        Collage containingCollage,
                        Envi environment) {
                        
	if (! (edge instanceof Hyperedge)) {
		return; // can only display Hyperedges
	}
	
	Hyperedge hyper = (Hyperedge)edge;
	
	PointSequence ps = hyper.getAttachedPoints();
	int numPoints = ps.size();
	if (numPoints == 0) {
		return; // not a propper hyperedge, but we do not complain here
	}
	
	int i = 0;
	double sx = 0.0;
	double sy = 0.0;
	
	// Calculate sum of all coordinates
	//
	Point p = (Point)ps.getAt(0);
	while (p != null) {
		sx += p.get(0);
		sy += p.get(1);
		p = (Point)ps.getAt(++i);
	}
	
	// Calculate center point
	//
	double mx = sx / numPoints;
	double my = sy / numPoints;
	
	// Draw tentacles 
	//
	graphics.setColor(Color.red);
	p = (Point)ps.getAt(0);
	i = 0;
	while (p != null) {
		graphics.drawLine(xOut(p.get(0)), 
		                  yOut(p.get(1)), 
		                  xOut(mx), 
		                  yOut(my));		
		p = (Point)ps.getAt(++i);
	}
	
	// Draw box and label
	//
	graphics.setColor(Color.white);
	graphics.fillRect(xOut(mx)-5, yOut(my)-5, 10, 10);
	graphics.setColor(Color.black);
	graphics.drawString(hyper.getLabel(), xOut(mx)-4, yOut(my)+6);
	
}                        

} // class AWTDisplay
