
package collage.ui;

import java.awt.Frame;
import java.awt.Event;
import java.awt.Dimension;
import java.applet.Applet;

/**
 * Provides a <code>main()</code> function and a frame for the 
 * CollageSystem applet to run the CollageSystem outside a 
 * web browser.
 * <p>
 * The system can be started in stand-alone-mode by typing 
 * <code>java Application</code> at the command line.
 */
public class Application extends Frame
{

    public static void startApplet(String className, 
                                   String title, 
                                   String args[])
    {
		Applet a;
		Dimension appletSize;

		try 
		{
			//
			// Create an instance of your applet class.
			//
			a = (Applet) Class.forName(className).newInstance();
		}
		catch (ClassNotFoundException e) { return; }
		catch (InstantiationException e) { return; }
		catch (IllegalAccessException e) { return; }

		//
		// Initialize the applet.
		//
		a.init();

		//
		// Create new application frame window 
		// and add the applet to it.
		//
		Application f = new Application(title);
		f.add("Center", a);

		//
		// Resize and show the frame window to fit applet.
		// Assumes that the applet sets its own size
		// otherwise, you should set a specific size here.
		//
		appletSize = a.size();
		f.pack();
		f.resize(appletSize);  
		f.show();

		//
		// Start the applet
		//		
		a.start();
  
    } // end startApplet()
  
  
  	//
    // Constructor
    // Needed to pass window title to class Frame
    //
    public Application(String name)
    {
    	super(name);
    }


	// 
    // handleEvent()
    // Needed to allow window close.
    //
    public boolean handleEvent(Event e)
    {
    	//
		// Window Destroy event.
		//
		if (e.id == Event.WINDOW_DESTROY)
		{
			// exit the program
			System.exit(0);
			return true;
		}

		//
		// Unhandled events.
		//
		return super.handleEvent(e);

	} // end handleEvent()
	
	
	/**
	 * <code>main()</code> function.
	 * <p>
	 * Launches a new CollageSystem applet.
	 */
	public static void main (String[] args)
	{
		startApplet ("CollageApplet", "CollageSystem", args);
	}
	

} // end class Application


