/*
 * @(#)ListOfDisplays.java
 * 
 */

package collage.ui;

import java.awt.*;

import openstar.generic.*;
import openstar.util.*;
import collage.generic.*;

/**
 * A list of currently active displays in a collage grammar
 * environment.
 * <p>
 * This is an example of a small <em>view</em> component. Once
 * created (and added to an arbitrary panel), the list gets
 * notified of changes to the environment and updates itself
 * accordingly.
 * 
 * @version 11 Jun 1997
 * @author 	Nils Schwabe
 */ 
public class ListOfDisplays extends Panel
                            implements ModelChangeListener
{

private List list; 


public ListOfDisplays(Envi envi) {
	//
	// Do all that AWT stuff
	//
	setLayout(new BorderLayout());
	Label label = new Label("Displays", Label.CENTER);
	label.setFont(new Font("SansSerif", Font.BOLD, 14));
	label.setForeground(Color.darkGray);
	add("North", label);
	list = new List(10, false);
	list.setBackground(Color.darkGray);
	list.setForeground(Color.white);
	add("Center", list);
	
	//
	// Register for event notifications
	//
	envi.addModelChangeListener(this);		
}


public void modelChange(ModelChangeEvent event) {
	updateDisplayList((Envi)event.getModel());
}


private void updateDisplayList(Envi envi) {
	int i = 0;
	Display display;
	list.removeAll();
	while ((display = (Display)envi.getDisplays().getAt(i)) != null) {
		String name = display.getName();
		if (name != null) {
			list.add(name);
		} else {
			list.add(display.getClass().getName());
		}
		i++;
	}
}


} // class ListOfDisplays

                     
