/*
 * @(#)PreviewDisplay.java
 * 
 */

package collage.ui;

import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;

import openstar.util.Point;
import collage.kernel.*;
import collage.generic.Envi;

/**
 * CollageSystem Preview display.
 * <p>
 * Note: Don't get confused by the name, this class <em>does not</em>
 * implement the <code>Display</code> interface. It is merely a helper
 * class for the class <code>Previewer</code>.
 */
public class PreviewDisplay
       extends Panel 
       implements MouseListener, MouseMotionListener
{

/**
 * Off-screen image. This is used to avoid flickering when dragging
 * the displayed collages.
 */
protected Image offscreen;
protected Dimension offscreensize;
protected Graphics offgraphics;

/** Collage AWT display */
protected AWTDisplay display; 

/** The currently displayed collage. */
protected Collage curCollage;

/** Reference to the collage grammar environment. */
protected Envi curEnvi;

/**
 * Hot spots for drag operations and origin offset.
 */
protected java.awt.Point hotSpot1, offset;


/**
 * Message strings to be shown in the preview window.
 */
protected Label label;
protected final String initMessage = "Ready...";

/**
 * Color of marks 
 */
protected final Color markColor = Color.red;	
    
    
public PreviewDisplay()
{
	hotSpot1 = new java.awt.Point(0,0);
	offset = new java.awt.Point(0,0);
	addMouseListener(this);
	addMouseMotionListener(this);
	
	setLayout(new BorderLayout());	
	label = new Label(initMessage, Label.LEFT);
	label.setFont(new Font("SansSerif", Font.BOLD, 14));
	label.setForeground(Color.darkGray);
	add("North", label);	
}


public void displayCollage(Envi envi,
                           Collage collage,
                           int index,
                           int total)  {	
	curCollage = collage;
	curEnvi = envi;
	repaint();	
}


public void zoomIn() {
	display.zoomIn();
	repaint();	
}



public void zoomOut() {
	display.zoomOut();
	repaint();	
}


public void resetView() {
	display.resetView();
	repaint();	
}


public void showMessage (String msg)
{
	label.setText(msg);    
}



/**
 * Does not clear the background. Simply calls paint().
 */
public void update(Graphics g) 
{
	paint (g);
}

/**
 * Creates the offscreen and blits it to the screen.
 */
public void paint(Graphics g)
{
	Dimension d = getSize();

	//
	// If there's no offscreen or the size has been changed then
	// create a new offscreen.
	//
	if (   (offscreen == null) 
		|| (d.width != offscreensize.width) 
		|| (d.height != offscreensize.height)) 
	{
	    offscreen = createImage(d.width, d.height);
		offscreensize = d;
	    offgraphics = offscreen.getGraphics();
	    offgraphics.setFont(getFont());  
	    display = new AWTDisplay(offgraphics, d);
	}

	
	//
	// Output content into the offscreen graphics.
	//
	offgraphics.setColor(getBackground());
	offgraphics.fillRect(0, 0, d.width, d.height);
	
	if (curCollage != null) {
		display.setOffset(offset);
		display.displayCollage(curEnvi, curCollage);
	}
	
	//
	// Blit the offscreen graphics to the screen.
	//
	g.drawImage (offscreen, 0, 0, null);
}


public void mouseClicked (MouseEvent event)
{
}

public void mousePressed (MouseEvent event)
{
    hotSpot1.x = event.getX();
    hotSpot1.y = event.getY();
	repaint();
}

public void mouseReleased (MouseEvent event)
{
	repaint();
}

public void mouseEntered (MouseEvent event)
{
}

public void mouseExited (MouseEvent event)
{
}	

public void mouseDragged (MouseEvent event)
{
    offset.x += (event.getX() - hotSpot1.x);
    offset.y -= (event.getY() - hotSpot1.y); // y is flipped
    hotSpot1.x = event.getX();
    hotSpot1.y = event.getY();
	repaint();	
}

public void mouseMoved (MouseEvent event)
{	
}

} // class PreviewDisplay


