/*
 * @(#)StdDerivator.java
 * 
 */

package collage.ui;

import openstar.generic.Parameter;
import collage.generic.*;
import collage.kernel.*;

/**
 * Standard derivator class.
 *
 * @version 11 Jun 1997
 * @author 	Nils Schwabe
 */ 
public class StdDerivator implements Derivator
{

public void doDerivation(Envi envi, CollageList collages) {

	collages.removeAllElements();
	
	if (   envi.getGrammar() == null
	    || envi.getGrammar().getStart() == null) {
		return;
	}
	
	int maxDerivation[] = new int[1];
	int tableNr[] = new int[1];
	TableInfo defaultTableInfo = new TableInfo(0, false, false, false);
	TableInfo tableInfo;
	int step = 0;
	boolean kInverse;
	Parameter pkinv = envi.getParamSet().get("kinverse");
	if (pkinv == null) {
		kInverse = false;
	} else {
		kInverse = ((Boolean)pkinv.getValue()).booleanValue();
	}
	
	collages.addElement(envi.getGrammar().getStart().clone()); // always insert start collage
	
	if (envi.getTable().getMaxUntil(maxDerivation)) {

		step = 1;
		boolean endOfDerivation = false;
		while (step <= maxDerivation[0] && !endOfDerivation) {
		
			Base b = new Base();
			TableElement tableElem;
			int i = step;

			while (   (! endOfDerivation)
			       && ((tableElem = envi.getTable().nextTable(i, tableNr)) == null)) {
				i++;
				if (i > maxDerivation[0]) {
					endOfDerivation = true;
				}
			}
			
			if (! endOfDerivation) {
				tableInfo = envi.getTableInfoList().find(tableNr[0]);
				
				if (tableInfo == null) {
					defaultTableInfo.setTable(tableNr[0]);
					tableInfo = defaultTableInfo;
				}
				
				if (! b.build(envi.getGrammar().getStart(), envi.getGrammar().getRules(),
				            tableInfo, kInverse)) {
					endOfDerivation = true;
				}				            
				
				if (! endOfDerivation) {
					envi.getGrammar().getStart().deriveWithBase(b, kInverse);
					collages.addElement(envi.getGrammar().getStart().clone());
				}
				
				step++;
				
			} // if			       			
			
		} // while

	} // if
}


} // class StdDerivator

