/*
 * @(#)VRMLFactory.java
 * 
 */

package collage.vrml;

import openstar.generic.*;
import collage.generic.*;

/**
 * VRML display factory class.
 * <p>
 * This factory generates objects of class <code>VRMLDisplay</code>.
 * <p>
 * <strong>Required parameters:</strong>
 * <p>
 * <em>None.</em>
 * <p>
 * <strong>Optional parameters:</strong>
 * <p><ul>
 * <li><code>filename</code><br>
 * Type: <em>String</em><br>
 * Defines the filename base (without extension) for the
 * generated VRML files. The actual file names will also
 * contain an index number and the extension <code>.wrl</code>.
 * <li><code>viewer</code><br>
 * Type: <em>String</em><br>
 * Defines the name (and parameters) of the external VRML viewer
 * program. The filename of the VRML file is appended to this
 * string to form the actual command that is being executed.
 * </ul>
 */
public class VRMLFactory extends DisplayFactory
{

protected final String FILENAME = "filename";
protected final String VIEWER = "viewer";

public int newParam(String name, Object value) {

	if (name.equals(FILENAME) || name.equals(VIEWER)) {
		if (! (value instanceof String)) {
			return Factory.ERR_WRONG_TYPE;
		}
	}
	return super.newParam(name, value);
}


public String[] missingParams() {

	return null;
}


public Object create() {

	if (missingParams() != null) {
		return null;
	}
	VRMLDisplay vrml;
	Parameter filename = get(FILENAME);
	if (filename != null) {
		vrml = new VRMLDisplay((String)filename.getValue());
	} else {
		vrml = new VRMLDisplay();
	}
	Parameter name = get(NAME);
	if (name != null) {
		vrml.setName((String)name.getValue());
	}
	Parameter viewer = get(VIEWER);
	if (viewer != null) {
		vrml.setViewer((String)viewer.getValue());
	}
	return vrml;
}


} // class VRMLFactory

