/*
 * @(#)VRMLPart.java
 * 
 */

package collage.vrml;

import openstar.generic.*;
import openstar.util.*;
import collage.generic.*;
import collage.kernel.*;

/**
 * VRML part class.
 * <p>
 * Parts of this type can be used for generating all kinds
 * of VRML objects. Each object may have a color, a transformation
 * and a native VRML code sequence.
 * <p>
 * <strong>Required parameters:</strong>
 * <p>
 * <em>None.</em>
 * <p>
 * <strong>Optional parameters:</strong>
 * <p><ul>
 * <li><code>color</code><br>
 * Type: <em>Point</em>, i.e. 3-tupel of the form "(r,g,b)"<br>
 * Defines the diffuse RGB color of an object. Each color channel has
 * a range from 0 to 255.
 * <li><code>native</code><br>
 * Type: <em>String</em><br>
 * Contains the VRML code for the object.
 * </ul>
 * @version 18 Jun 1997
 * @author 	Nils Schwabe
 */ 
public class VRMLPart extends Part implements IVRMLPart
{

public VRMLPart(ParamSet params) {
	super(params, 3);
}

protected VRMLPart() {
}

public void vrmlOutput(java.io.PrintWriter writer) {
	
	writer.println("\nSeparator {");
	
	//
	// Color
	//
	Parameter pColor = params.get("color");
	if (pColor != null && pColor.getValue() instanceof Point) {
		Point color = (Point)pColor.getValue();
		writer.println("  Material {");
		writer.println("    diffuseColor " 
		               + color.get(0) / 255.0 + " "
		               + color.get(1) / 255.0 + " "
		               + color.get(2) / 255.0);
		writer.println("    ambientColor .5 .5 .5");
		writer.println("  }");
	}
	
	//
	// Transformation
	//
	if (dimensions == 3 && trans instanceof MatrixTrans) {
		writer.println("  MatrixTransform { matrix ");
		MatrixTrans m = (MatrixTrans)trans;
		writer.print(m.get(0,0)+" "+m.get(1,0)+" "+m.get(2,0)+" "+m.get(3,0));
		writer.print(" "+m.get(0,1)+" "+m.get(1,1)+" "+m.get(2,1)+" "+m.get(3,1));
		writer.print(" "+m.get(0,2)+" "+m.get(1,2)+" "+m.get(2,2)+" "+m.get(3,2));
		writer.print(" "+m.get(0,3)+" "+m.get(1,3)+" "+m.get(2,3)+" "+m.get(3,3));
		writer.println("}");
	}
	
	//
	// Native definition
	//
	Parameter pNative = params.get("native");
	if (pNative != null && pNative.getValue() instanceof String) {
		writer.println((String)pNative.getValue());
	}
	
	writer.println("\n} #Separator");
}


public Object clone() {

	VRMLPart newPart = new VRMLPart();
	cloneInto(newPart);
	return newPart;
}



} // class VRMLPart
