/*
 * @(#)Model.java
 * 
 */

package openstar.generic;

import openstar.util.*;

/**
 * Generic model class.
 * <p>
 * This class provides a standard implementation of the <code>IModel</code>
 * interface that can be used by most model classes.
 *
 * @version 11 Jun 1997
 * @author 	Nils Schwabe 
 */
public abstract class Model implements IModel, EventDelivery
{

protected EventSupport support;
protected boolean enableNotifications;

public Model() {
	support = new EventSupport();
	enableNotifications = true;
}


public void addModelChangeListener(ModelChangeListener listener) {
	support.addEventListener(listener);
}


public void removeModelChangeListener(ModelChangeListener listener) {
	support.removeEventListener(listener);
}


public void setModelChanged(Object source) {
	if (enableNotifications) {
		support.fireEvent(new ModelChangeEvent(source, this), this);
	}
}


/**
 * Fires a <code>ModelChangeEvent</code> to all registered listeners.
 * <p>
 * Nothing happens if the notifications switch of this model is "off"
 * (<code>setEnableNotifications()</code>, <code>getEnableNotifications()</code>).
 * <p>
 * The originator of the event is set to be the model itself.
 */
protected void setModelChanged() {
	if (enableNotifications) {
		support.fireEvent(new ModelChangeEvent(this, this), this);
	}
}


public void setEnableNotifications(boolean enable) {
	enableNotifications = enable;
}


public boolean getEnableNotifications() {
	return enableNotifications;
}


public void deliverEvent(java.util.EventListener target, Event event) {
	((ModelChangeListener)target).modelChange((ModelChangeEvent)event);
}


} // class Model
