/*
 * @(#)ModelChangeEvent.java
 * 
 */

package openstar.generic;

/**
 * OpenStar model change event class.
 */
public class ModelChangeEvent extends Event
{

/**
 * The model that has been changed.
 */
protected IModel model;

/**
 * @param source The originator of this event. This is usually either
 * the model itself, or the object that changed the model.
 * @param model The changed model
 */
public ModelChangeEvent(Object source, IModel model) {
	super(source);
	this.model = model;
}

/**
 * Returns the changed model.
 */
public IModel getModel() {
	return model;
}

} // class ModelChangeEvent

