/*
 * @(#)ModelSelectionEvent.java
 * 
 */

package openstar.generic;

/**
 * OpenStar model selection event class.
 */
public class ModelSelectionEvent extends Event
{

/**
 * The model selection that has been changed.
 */
protected ModelSelection selection;

/**
 * @param source The originator of this event. This is usually either
 * the model selection itself, or the object that changed the selection.
 * @param model The changed model selection
 */
public ModelSelectionEvent(Object source, ModelSelection selection) {
	super(source);
	this.selection = selection;
}

/**
 * Returns the changed model selection.
 */
public ModelSelection getModelSelection() {
	return selection;
}

} // class ModelSelectionEvent

