/*
 * @(#)ParamSet.java
 * 
 */

package openstar.generic;

import java.util.Hashtable;

/**
 * A <code>ParamSet</code> is a set of a <code>Parameters</code>.
 *
 * @version 11 Jun 1997
 * @author 	Nils Schwabe
 */ 
public class ParamSet
{

/** 
 * The parameters are actually stored in a hash table that
 * uses the parameter names as keys.
 */ 
private Hashtable params;

/** 
 * Creates an empty parameter set.
 */
public ParamSet() {

	params = new Hashtable();
}

/**
 * Puts a given parameter into the set. If a parameter with the same
 * name is already stored in the set, then it is replaced by the new
 * parameter and is returned by this method. Otherwise, <code>null</code>
 * is returned.
 * <p>
 * Note: To change the <em>value</em> of an existing parameter without
 * creating a new parameter, you have to use something like
 * <code>paramset.get(paraname).setValue(newValue)</code>. 
 */
public Parameter put(Parameter param) {

	return (Parameter)params.put(param.getName(), param);
}

/**
 * Creates a new parameter and puts it into the set. If a parameter 
 * with the same name is already stored in the set, then it is replaced by 
 * the newly created parameter is returned by this method. Otherwise, 
 * <code>null</code> is returned.
 * <p>
 * Note: To change the <em>value</em> of an existing parameter without
 * creating a new parameter, you have to use something like
 * <code>paramset.get(paraname).setValue(newValue)</code>.
 */
public Parameter put(String name, Object value) {

	return (Parameter)params.put(name, new Parameter(name, value));
}

/**
 * Returns the parameter object for a given name or <code>null</code>
 * if no such parameter is stored in this set.
 */
public Parameter get(String name) {

	return (Parameter)params.get(name);
}

/**
 * Creates a shallow copy of this parameter set.
 */
public Object clone() {

	ParamSet ps = new ParamSet();
	ps.params = (Hashtable)this.params.clone();
	return ps;
}
	

} // class ParamSet


