/*
 * @(#)ClassTest.java
 * 
 */
 
package openstar.util;

/**
 * Utility class to test objects for beeing of a specific type.
 *
 * @version 09 Apr 1997
 * @author 	Nils Schwabe 
 */
public class ClassTest
{

private Class testClass;
private boolean polymorphic;

/**
 * Constructs a new ClassTest object that is used to test
 * objects against a given type signature.
 * @param testClass The class object which objects should be tested against.
 * @param polymorphic <code>false</code> - an object must be of the exact type to pass the test<br>
 *                    <code>true</code> - objects may be members of subclass(es) of testClass to pass the test.
 */
public ClassTest(Class testClass, boolean polymorphic) {

	this.testClass = testClass;
	this.polymorphic = polymorphic;
}

/**
 * Tests and object against the predefined type.
 * @return <code>true</code> - if the object passed the type test.
 */
public boolean isValid(Object object) {

	if (polymorphic) {
		return testClass.isInstance(object);
	} else {
		return object.getClass() == testClass;
	}
}


/**
 * Returns the name of the test class.
 */
public String getClassName() {

	return testClass.getName();
}

/**
 * Returns the polymorphic indicator.
 */
public boolean isPolymorphic() {

	return polymorphic;
}


} // class ClassTest
