/*
 * @(#)MatrixTrans.java
 * 
 */

package openstar.util;

/**
 * Matrix transformation class.
 *
 * @version 09 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class MatrixTrans extends Matrix implements Transformation
{

static private Point t3, t4, r3, r4; // used for optimization (see below)

static {
	t3 = new Point(3);
	t4 = new Point(4);
	r3 = new Point(3);
	r4 = new Point(4);
}

public MatrixTrans(int rows, int columns) {
	
	super(rows, columns);
}	
	

public synchronized void transform(Point p, Point result) {

	int dim = p.getDim();
	
	//
	// This routine is very frequently used within the system, so
	// we optimize away the allocation of new Point objects for
	// the common cases of 2D and 3D points.
	//
	if (dim == 2) {
		t3.assign(p);
		t3.set(dim, 1);
		multiply(t3, r3);
		result.assign(r3);
	} else if (dim == 3) {
		t4.assign(p);
		t4.set(dim, 1);
		multiply(t4, r4);
		result.assign(r4);
	} else {
		Point t = new Point(dim+1);
		Point r = new Point(dim+1);
		t.assign(p);
		t.set(dim, 1);
		multiply(t, r);
		result.assign(r);
	}
}


public Transformation chain(Transformation outer) {

	if (! (outer instanceof MatrixTrans)) {
		return null;
	}
	MatrixTrans outa = (MatrixTrans)outer;
	if (outa.getColumns() != this.getRows()) {
		System.err.println ("MatrixTrans.chain(): Can't multiply (column/row) mismatch");
		return null;
	}
	MatrixTrans n = new MatrixTrans(this.getRows(), outa.getColumns());
	multiply(outa, n);
	return n;
}


public Object clone() {


	MatrixTrans newTrans = new MatrixTrans(this.getRows(), this.getColumns());
	copyInto(newTrans);
	return newTrans;
}



} // class MatrixTrans
