/*
 * @(#)PointSequence.java
 * 
 */

package openstar.util;

import java.util.*;

/**
 * A class representing a sequence of points in the n-dimensional 
 * euclidean space.
 *
 * @version 09 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class PointSequence extends TCTList 
{

public PointSequence() {
	super("openstar.util.Point", true);
}


/**
 * Makes a deep copy of the PointSequence. All points of the sequence
 * are also cloned.
 */
public Object clone() {
	PointSequence newPS = new PointSequence();
	copyInto(newPS);
	return newPS;
}


/**
 * Applies a special equality test.
 * <p>
 * <code>true</code> is returned if both sequences have the same
 * length and there exists a rotation or a mirroring of the points
 * in the lists, after which both lists are equal.
 */
public boolean cyclicIdentical(PointSequence cmp) {
	int len, offs,i;
	Point p, c;
	
	if ((len = length()) != cmp.length()) {
		return false;
	}
	if (len == 0) {
		return true;
	}
	
	// Check all possible rotations:
	offs = 0;
	while (offs < len) {
		for (i=0; i<len; i++) {
			p = (Point)getAt(i);
			c = (Point)cmp.getAt((offs+i)%len);
			if (! p.equals(c)) {
				break;
			}
		}
		if (i == len) {
			return true;
		}
		offs++;
	}
	
	// Check for mirroring:
	offs = 0;
	while (offs < len) {
		for (i=0; i<len; i++) {
			p = (Point)getAt(i);
			c = (Point)cmp.getAt(len-1-((offs+i)%len));	
			if (! p.equals(c)) {
				break;
			}
		}
		if (i == len) {
			return true;
		}
		offs++;
	}
	
	return false;
}

} // class PointSequence


