/*
 * @(#)TCTList.java
 * 
 */

package openstar.util;

import java.util.*;

/**
 * Typed list that contains transformable objects.
 *
 * @version 14 Apr 1997
 * @author 	Nils Schwabe
 */ 
public class TCTList extends TypedList 
                     implements Transformable
{

/**
 * The class of the objects specified by the first parameter
 * must implement the Transformable interface.
 */
public TCTList(String elementClass, boolean polymorphic) {
	
	super(elementClass, true);
}


/**
 * Makes a deep copy of the list. All objects of the list
 * must implement the Transformable interface and are also cloned.
 */
public Object clone() {

	TCTList newTCT = new TCTList(getElemClassName(), isPolymorphic());
	int mySize = vector.size();
	Transformable curMine;	
	for (int i=0; i < mySize; i++) {
		curMine = (Transformable)vector.elementAt(i);
		newTCT.vector.addElement(curMine.clone());
	}
	return newTCT;
}


/**
 * Deep-copies the list into a given destinaton list. All objects of the list
 * must implement the Transformable interface and are cloned.
 */
protected void copyInto(TypedList dest) {

	int mySize = vector.size();
	Transformable curMine;	
	for (int i=0; i < mySize; i++) {
		curMine = (Transformable)vector.elementAt(i);
		dest.vector.addElement(curMine.clone());
	}
}


/**
 * Transforms all objects of the list.
 */
public void transform(Transformation t) {

	if (t == null) {
		throw new IllegalArgumentException("Transformation is null");
	}
	Transformable cur;	
	int mySize = vector.size();
	
	for (int i = 0; i < mySize; i++) {
		cur = (Transformable)vector.elementAt(i);
		if (cur != null) {
			cur.transform(t);
		} else {
			throw new IllegalArgumentException("Object at index "+i+" is null.");
		}
	}
}


} // class TCTList


