/*
 * @(#)Transformable.java
 * 
 */

package openstar.util;

/**
 * Interface that all transformable objects must implement.
 * A transformable object is an object to which a Transformation
 * can be applied. Moreover, a transformable object must also
 * implement a clone() method to make a deep copy of itself.
 *
 * @version 14 Apr 1997
 * @author 	Nils Schwabe
 */ 
public interface Transformable 
{


/**
 * Transforms this object using the given transformation.
 */
public abstract void transform(Transformation t);


public Object clone();



} // interface Transformable
