/*
 * @(#)Transformation.java
 * 
 */

package openstar.util;

/**
 * Transformation interface.
 *
 * @version 04 Jun 1997
 * @author 	Nils Schwabe
 */ 
public interface Transformation extends Cloneable
{
	/**
	 * The transformation method.
	 * @param p The point that is to be transformed.
	 * @param result The transformed point, which may actually be the same object as p.
	 */
	public void transform(Point p, Point result);


	/**
	 * Returns a new transformation that represents outer(this),
	 * or null if no such transformation could be generated.
	 */
	public Transformation chain(Transformation outer);
	

} // interface Transformation
